/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTAppointment;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import fr.gouv.vitam.tools.javalibpst.PSTTimeZone;
import java.io.UnsupportedEncodingException;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class PSTAppointmentException {
    static final short ARO_SUBJECT = 1;
    static final short ARO_MEETINGTYPE = 2;
    static final short ARO_REMINDERDELTA = 4;
    static final short ARO_REMINDER = 8;
    static final short ARO_LOCATION = 16;
    static final short ARO_BUSYSTATUS = 32;
    static final short ARO_ATTACHMENT = 64;
    static final short ARO_SUBTYPE = 128;
    static final short ARO_APPTCOLOR = 256;
    private final short OverrideFlags;
    private String Subject;
    private int MeetingType;
    private int ReminderDelta;
    private boolean ReminderSet;
    private String Location;
    private int BusyStatus;
    private int Attachment;
    private boolean SubType;
    private int AppointmentColor;
    private final int writerVersion2;
    private Date StartDate;
    private Date EndDate;
    private Date OriginalStartDate;
    private int ChangeHighlightValue = -1;
    private PSTAppointment embeddedMessage = null;
    private final PSTAppointment appt;
    private final int length;
    private int extendedLength;
    static DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;

    public String getSubject() {
        if ((this.OverrideFlags & 1) != 0) {
            return this.Subject;
        }
        return this.appt.getSubject();
    }

    public int getMeetingType() {
        if ((this.OverrideFlags & 2) != 0) {
            return this.MeetingType;
        }
        return this.appt.getMeetingStatus();
    }

    public int getReminderDelta() {
        if ((this.OverrideFlags & 4) != 0) {
            return this.ReminderDelta;
        }
        return this.appt.getReminderDelta();
    }

    public boolean getReminderSet() {
        if ((this.OverrideFlags & 8) != 0) {
            return this.ReminderSet;
        }
        return this.appt.getReminderSet();
    }

    public String getLocation() {
        if ((this.OverrideFlags & 0x10) != 0) {
            return this.Location;
        }
        return this.appt.getLocation();
    }

    public int getBusyStatus() {
        if ((this.OverrideFlags & 0x20) != 0) {
            return this.BusyStatus;
        }
        return this.appt.getBusyStatus();
    }

    public boolean isAttachmentsPresent() {
        return (this.OverrideFlags & 0x40) != 0 && this.Attachment == 1;
    }

    public boolean getSubType() {
        if ((this.OverrideFlags & 0x80) != 0) {
            return this.SubType;
        }
        return this.appt.getSubType();
    }

    public int getColor() {
        if ((this.OverrideFlags & 0x100) != 0) {
            return this.AppointmentColor;
        }
        return this.appt.getColor();
    }

    public int getChangeHighlightValue() {
        return this.ChangeHighlightValue;
    }

    public String getDescription() {
        if (this.embeddedMessage != null) {
            return this.embeddedMessage.getBodyPrefix();
        }
        return null;
    }

    public Date getDTStamp() {
        Date ret = null;
        if (this.embeddedMessage != null) {
            ret = this.embeddedMessage.getOwnerCriticalChange();
        }
        if (ret == null) {
            Calendar c = Calendar.getInstance(PSTTimeZone.utcTimeZone);
            ret = c.getTime();
        }
        return ret;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public Date getEndDate() {
        return this.EndDate;
    }

    public Date getOriginalStartDate() {
        return this.OriginalStartDate;
    }

    public boolean isEmbeddedMessagePresent() {
        return this.embeddedMessage != null;
    }

    public PSTAppointment getEmbeddedMessage() {
        return this.embeddedMessage;
    }

    PSTAppointmentException(byte[] recurrencePattern, int offset, int writerVersion2, PSTAppointment appt) {
        byte[] tmp;
        this.writerVersion2 = writerVersion2;
        int initialOffset = offset;
        this.appt = appt;
        this.embeddedMessage = null;
        PSTTimeZone tz = appt.getRecurrenceTimeZone();
        this.StartDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), tz);
        this.EndDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4), tz);
        this.OriginalStartDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4), tz);
        this.OverrideFlags = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 2);
        offset += 2;
        if ((this.OverrideFlags & 1) != 0) {
            short SubjectLength2 = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 2, offset + 2);
            tmp = new byte[SubjectLength2];
            System.arraycopy(recurrencePattern, offset += 2, tmp, 0, SubjectLength2);
            try {
                this.Subject = new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            offset += SubjectLength2;
        }
        if ((this.OverrideFlags & 2) != 0) {
            this.MeetingType = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
        }
        if ((this.OverrideFlags & 4) != 0) {
            this.ReminderDelta = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
        }
        if ((this.OverrideFlags & 8) != 0) {
            this.ReminderSet = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4) != 0;
            offset += 4;
        }
        if ((this.OverrideFlags & 0x10) != 0) {
            short LocationLength2 = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 2, offset + 2);
            tmp = new byte[LocationLength2];
            System.arraycopy(recurrencePattern, offset += 2, tmp, 0, LocationLength2);
            try {
                this.Location = new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            offset += LocationLength2;
        }
        if ((this.OverrideFlags & 0x20) != 0) {
            this.BusyStatus = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
        }
        if ((this.OverrideFlags & 0x40) != 0) {
            this.Attachment = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
        }
        if ((this.OverrideFlags & 0x80) != 0) {
            this.SubType = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4) != 0;
            offset += 4;
        }
        if ((this.OverrideFlags & 0x100) != 0) {
            this.AppointmentColor = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
        }
        this.length = offset - initialOffset;
    }

    void ExtendedException(byte[] recurrencePattern, int offset) {
        int initialOffset = offset;
        if (this.writerVersion2 >= 12297) {
            int ChangeHighlightSize = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            this.ChangeHighlightValue = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
            offset += ChangeHighlightSize;
        }
        int ReservedBlockEESize = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        offset += 4 + ReservedBlockEESize;
        if ((this.OverrideFlags & 0x11) != 0) {
            PSTTimeZone tz = this.appt.getRecurrenceTimeZone();
            this.StartDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), tz);
            this.EndDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4), tz);
            this.OriginalStartDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4), tz);
            offset += 4;
        }
        if ((this.OverrideFlags & 1) != 0) {
            short WideCharSubjectCharLength = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 2);
            byte[] WideCharSubject = new byte[WideCharSubjectCharLength * 2];
            System.arraycopy(recurrencePattern, offset += 2, WideCharSubject, 0, WideCharSubject.length);
            try {
                this.Subject = new String(WideCharSubject, "UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            offset += WideCharSubject.length;
        }
        if ((this.OverrideFlags & 0x10) != 0) {
            short WideCharLocationCharLength = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 2);
            byte[] WideCharLocation = new byte[WideCharLocationCharLength * 2];
            System.arraycopy(recurrencePattern, offset += 2, WideCharLocation, 0, WideCharLocation.length);
            try {
                this.Location = new String(WideCharLocation, "UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            offset += WideCharLocation.length;
        }
        if ((this.OverrideFlags & 0x11) != 0) {
            ReservedBlockEESize = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4 + ReservedBlockEESize;
        }
        this.extendedLength = offset - initialOffset;
    }

    void setEmbeddedMessage(PSTAppointment embeddedMessage) {
        this.embeddedMessage = embeddedMessage;
    }

    int getLength() {
        return this.length;
    }

    int getExtendedLength() {
        return this.extendedLength;
    }

    public String toString() {
        String result = "      OverrideFlags:" + Integer.toHexString(this.OverrideFlags) + "\n";
        if ((this.OverrideFlags & 1) != 0) {
            result = result + "      Changed Subject: " + this.getSubject() + "\n";
        }
        if ((this.OverrideFlags & 2) != 0) {
            result = result + "      Changed MeetingType: " + this.getMeetingType() + "\n";
        }
        if ((this.OverrideFlags & 8) != 0) {
            result = result + "      Changed Reminder: " + this.getReminderSet() + "\n";
        }
        if ((this.OverrideFlags & 4) != 0) {
            result = result + "      Changed ReminderDelta: " + this.getReminderDelta() + "\n";
        }
        if ((this.OverrideFlags & 0x10) != 0) {
            result = result + "      Changed Location: " + this.getLocation() + "\n";
        }
        if ((this.OverrideFlags & 0x20) != 0) {
            result = result + "      Changed BusyStatus: " + this.getBusyStatus() + "\n";
        }
        if ((this.OverrideFlags & 0x80) != 0) {
            result = result + "      Changed SubType: " + this.getSubType() + "\n";
        }
        if ((this.OverrideFlags & 0x100) != 0) {
            result = result + "      Changed ApptColor: " + this.getColor() + "\n";
        }
        result = result + "      StartDate: " + this.getStartDate() + "\n";
        result = result + "      EndDate: " + this.getEndDate() + "\n";
        result = result + "      StartOriginalDate: " + this.getOriginalStartDate() + "\n";
        if (this.isEmbeddedMessagePresent()) {
            result = result + "      ChangedAppointment:\n        " + this.getEmbeddedMessage().toString().replaceAll("\\n", "\n        ");
        }
        return result;
    }
}

