/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.DescriptorIndexNode;
import fr.gouv.vitam.tools.javalibpst.PSTAppointmentRecurrence;
import fr.gouv.vitam.tools.javalibpst.PSTDescriptorItem;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTGlobalObjectId;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTTableBC;
import fr.gouv.vitam.tools.javalibpst.PSTTimeZone;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;

public class PSTAppointment
extends PSTMessage {
    PSTAppointment(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    PSTAppointment(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        super(theFile, folderIndexNode, table, localDescriptorItems);
    }

    public boolean getSendAsICAL() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(33280, 4));
    }

    public int getBusyStatus() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33285, 4));
    }

    public boolean getShowAsBusy() {
        return this.getBusyStatus() == 2;
    }

    public String getLocation() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33288, 4));
    }

    public Date getStartTime() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33293, 4));
    }

    public LocalDateTime getLocalStartTime() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33293, 4)).toInstant().atZone(this.getStartTimeZone().getSimpleTimeZone().toZoneId()).toLocalDateTime();
    }

    public PSTTimeZone getStartTimeZone() {
        return this.getTimeZoneItem(this.pstFile.getNameToIdMapItem(33374, 4));
    }

    public Date getEndTime() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33294, 4));
    }

    public LocalDateTime getLocalEndTime() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33294, 4)).toInstant().atZone(this.getStartTimeZone().getSimpleTimeZone().toZoneId()).toLocalDateTime();
    }

    public PSTTimeZone getEndTimeZone() {
        return this.getTimeZoneItem(this.pstFile.getNameToIdMapItem(33375, 4));
    }

    public PSTTimeZone getRecurrenceTimeZone() {
        String desc = this.getStringItem(this.pstFile.getNameToIdMapItem(33332, 4));
        byte[] tzData = this.getBinaryItem(this.pstFile.getNameToIdMapItem(33331, 4));
        if (desc == null || desc.isEmpty()) {
            desc = "Unknown";
        }
        if (tzData != null && tzData.length != 0) {
            return new PSTTimeZone(desc, tzData);
        }
        return null;
    }

    public int getDuration() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33299, 4));
    }

    public int getColor() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33300, 4));
    }

    public boolean getSubType() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33301, 4)) != 0;
    }

    public int getMeetingStatus() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33303, 4));
    }

    public int getResponseStatus() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33304, 4));
    }

    public boolean isRecurring() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(33315, 4));
    }

    public Date getRecurrenceBase() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(33320, 4));
    }

    public int getRecurrenceType() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33329, 4));
    }

    public String getRecurrencePattern() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33330, 4));
    }

    public byte[] getRecurrenceStructure() {
        return this.getBinaryItem(this.pstFile.getNameToIdMapItem(33302, 4));
    }

    public byte[] getTimezone() {
        return this.getBinaryItem(this.pstFile.getNameToIdMapItem(33331, 4));
    }

    public String getAllAttendees() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33336, 4));
    }

    public String getToAttendees() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33339, 4));
    }

    public String getCCAttendees() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33340, 4));
    }

    public int getAppointmentSequence() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33281, 4));
    }

    public boolean isOnlineMeeting() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(33344, 4));
    }

    public int getNetMeetingType() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33345, 4));
    }

    public String getNetMeetingServer() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33346, 4));
    }

    public String getNetMeetingOrganizerAlias() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33347, 4));
    }

    public boolean getNetMeetingAutostart() {
        return this.getIntItem(this.pstFile.getNameToIdMapItem(33349, 4)) != 0;
    }

    public boolean getConferenceServerAllowExternal() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(33350, 4));
    }

    public String getNetMeetingDocumentPathName() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33351, 4));
    }

    public String getNetShowURL() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33352, 4));
    }

    public Date getAttendeeCriticalChange() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(1, 5));
    }

    public Date getOwnerCriticalChange() {
        return this.getDateItem(this.pstFile.getNameToIdMapItem(26, 5));
    }

    public String getConferenceServerPassword() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(33353, 4));
    }

    public boolean getAppointmentCounterProposal() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(33367, 4));
    }

    public boolean isSilent() {
        return this.getBooleanItem(this.pstFile.getNameToIdMapItem(4, 5));
    }

    public String getRequiredAttendees() {
        return this.getStringItem(this.pstFile.getNameToIdMapItem(6, 5));
    }

    public int getLocaleId() {
        return this.getIntItem(16369);
    }

    public PSTGlobalObjectId getGlobalObjectId() {
        byte[] tmp = this.getBinaryItem(this.pstFile.getNameToIdMapItem(3, 5));
        if (tmp != null) {
            return new PSTGlobalObjectId(tmp);
        }
        return null;
    }

    public PSTGlobalObjectId getCleanGlobalObjectId() {
        byte[] tmp = this.getBinaryItem(this.pstFile.getNameToIdMapItem(35, 5));
        if (tmp != null) {
            return new PSTGlobalObjectId(tmp);
        }
        return null;
    }

    public static Date apptTimeToUTCDate(int minutes, PSTTimeZone tz) {
        long ms_since_16010101 = (long)minutes * 60000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        long tzOffset = tz == null ? 0L : (long)tz.getSimpleTimeZone().getOffset(ms_since_19700101);
        Date utcDate = new Date(ms_since_19700101 - tzOffset);
        return utcDate;
    }

    @Override
    public String toString() {
        String result = "IDs:\n  GlobalObjectID: " + this.getGlobalObjectId() + "\n  CleanGlobalID: " + this.getCleanGlobalObjectId() + "\n  LocaleID: " + this.getLocaleId() + "\n";
        result = result + "Info:\n  Subject: " + this.getSubject() + "\n  Location: " + this.getLocation() + "\n";
        result = result + "Peoples:\n  Required attendees: " + this.getRequiredAttendees() + "\n  All attendees: " + this.getAllAttendees() + "\n  To attendees: " + this.getToAttendees() + "\n  CC attendees: " + this.getCCAttendees() + "\n";
        result = result + "Flags:\n  Busy:" + this.getShowAsBusy() + "\n  MeetingStatus: " + this.getMeetingStatus() + "\n  ResponseStatus: " + this.getResponseStatus() + "\n  isRecursed: " + this.isRecurring() + "\n";
        result = result + "Time:\n  Start: " + this.getStartTime() + " [TZ=" + (Serializable)(this.getStartTimeZone() == null ? "Unknown" : this.getStartTimeZone().getSimpleTimeZone()) + "]\n  End: " + this.getEndTime() + " [TZ=" + (Serializable)(this.getEndTimeZone() == null ? "Unknown" : this.getEndTimeZone().getSimpleTimeZone()) + "]\n  Duration: " + this.getDuration() + "\n";
        result = result + "Recurrence:\n  Base: " + this.getRecurrenceBase() + "\n  Type: " + this.getRecurrenceType() + "\n  Pattern: " + this.getRecurrencePattern() + "\n";
        if (this.isRecurring()) {
            PSTAppointmentRecurrence par = new PSTAppointmentRecurrence(this.getRecurrenceStructure(), this, this.getRecurrenceTimeZone());
            result = result + par.toString() + "\n";
        }
        result = result + "Others\n  Color: " + this.getColor() + "\n";
        return result;
    }
}

