/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTObject;

class OffsetIndexItem {
    long indexIdentifier;
    long fileOffset;
    int size;
    long cRef;

    OffsetIndexItem(byte[] data, int pstFileType) {
        if (pstFileType == 14) {
            this.indexIdentifier = PSTObject.convertLittleEndianBytesToLong(data, 0, 4);
            this.fileOffset = PSTObject.convertLittleEndianBytesToLong(data, 4, 8);
            this.size = (int)PSTObject.convertLittleEndianBytesToLong(data, 8, 10);
            this.cRef = (int)PSTObject.convertLittleEndianBytesToLong(data, 10, 12);
        } else {
            this.indexIdentifier = PSTObject.convertLittleEndianBytesToLong(data, 0, 8);
            this.fileOffset = PSTObject.convertLittleEndianBytesToLong(data, 8, 16);
            this.size = (int)PSTObject.convertLittleEndianBytesToLong(data, 16, 18);
            this.cRef = (int)PSTObject.convertLittleEndianBytesToLong(data, 16, 18);
        }
    }

    public String toString() {
        return "OffsetIndexItem\nIndex Identifier: " + this.indexIdentifier + " (0x" + Long.toHexString(this.indexIdentifier) + ")\nFile Offset: " + this.fileOffset + " (0x" + Long.toHexString(this.fileOffset) + ")\ncRef: " + this.cRef + " (0x" + Long.toHexString(this.cRef) + " bin:" + Long.toBinaryString(this.cRef) + ")\nSize: " + this.size + " (0x" + Long.toHexString(this.size) + ")";
    }
}

