/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import java.io.UnsupportedEncodingException;

public class LZFu {
    public static final String LZFU_HEADER = "{\\rtf1\\ansi\\mac\\deff0\\deftab720{\\fonttbl;}{\\f0\\fnil \\froman \\fswiss \\fmodern \\fscript \\fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\\colortbl\\red0\\green0\\blue0\n\r\\par \\pard\\plain\\f0\\fs20\\b\\i\\u\\tab\\tx";

    public static String decode(byte[] data) throws PSTException {
        int compressedSize = (int)PSTObject.convertLittleEndianBytesToLong(data, 0, 4);
        int uncompressedSize = (int)PSTObject.convertLittleEndianBytesToLong(data, 4, 8);
        int compressionSig = (int)PSTObject.convertLittleEndianBytesToLong(data, 8, 12);
        int compressedCRC = (int)PSTObject.convertLittleEndianBytesToLong(data, 12, 16);
        if (compressionSig == 1967544908) {
            byte[] output = new byte[uncompressedSize];
            int outputPosition = 0;
            byte[] lzBuffer = new byte[4096];
            try {
                byte[] bytes = LZFU_HEADER.getBytes("US-ASCII");
                System.arraycopy(bytes, 0, lzBuffer, 0, LZFU_HEADER.length());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            int bufferPosition = LZFU_HEADER.length();
            int currentDataPosition = 16;
            while (currentDataPosition < data.length - 2 && outputPosition < output.length) {
                int flags = data[currentDataPosition++] & 0xFF;
                for (int x = 0; x < 8 && outputPosition < output.length; ++x) {
                    boolean isRef = (flags & 1) == 1;
                    flags >>= 1;
                    if (isRef) {
                        int refOffsetOrig = data[currentDataPosition++] & 0xFF;
                        int refSizeOrig = data[currentDataPosition++] & 0xFF;
                        int refOffset = refOffsetOrig << 4 | refSizeOrig >>> 4;
                        int refSize = (refSizeOrig & 0xF) + 2;
                        try {
                            int index = refOffset;
                            for (int y = 0; y < refSize && outputPosition < output.length; ++y) {
                                output[outputPosition++] = lzBuffer[index];
                                lzBuffer[bufferPosition] = lzBuffer[index];
                                ++bufferPosition;
                                bufferPosition %= 4096;
                                ++index;
                                index %= 4096;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    lzBuffer[bufferPosition] = data[currentDataPosition];
                    ++bufferPosition;
                    bufferPosition %= 4096;
                    output[outputPosition++] = data[currentDataPosition++];
                }
            }
            if (outputPosition != uncompressedSize) {
                throw new PSTException(String.format("Error decompressing RTF! Expected %d bytes, got %d bytes\n", uncompressedSize, outputPosition));
            }
            return new String(output).trim();
        }
        if (compressionSig == 1095517517) {
            byte[] output = new byte[data.length - 16];
            System.arraycopy(data, 16, output, 0, data.length - 16);
            return new String(output).trim();
        }
        return "";
    }
}

