/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.EmailTableModel;
import fr.gouv.vitam.tools.javalibpst.PSTActivity;
import fr.gouv.vitam.tools.javalibpst.PSTAppointment;
import fr.gouv.vitam.tools.javalibpst.PSTAttachment;
import fr.gouv.vitam.tools.javalibpst.PSTContact;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTMessageStore;
import fr.gouv.vitam.tools.javalibpst.PSTRss;
import fr.gouv.vitam.tools.javalibpst.PSTTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TestGui
implements ActionListener {
    private PSTFile pstFile;
    private EmailTableModel emailTableModel;
    private JTextPane emailText;
    private JPanel emailPanel;
    private JPanel attachPanel;
    private JLabel attachLabel;
    private JTextField attachText;
    private PSTMessage selectedMessage;
    private JFrame f = new JFrame("PST Browser");

    public TestGui(String filename) throws PSTException, IOException {
        try {
            this.pstFile = new PSTFile(filename);
            this.pstFile.setGlobalCodepage("windows-1252");
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.pstFile.getMessageStore());
        try {
            this.buildTree(top, this.pstFile.getRootFolder());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
        JTree folderTree = new JTree(top){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode nodeValue = (DefaultMutableTreeNode)value;
                if (nodeValue.getUserObject() instanceof PSTFolder) {
                    PSTFolder folderValue = (PSTFolder)nodeValue.getUserObject();
                    return folderValue.getDescriptorNodeId() + " - " + folderValue.getDisplayName() + " " + folderValue.getAssociateContentCount();
                }
                if (nodeValue.getUserObject() instanceof PSTMessageStore) {
                    PSTMessageStore folderValue = (PSTMessageStore)nodeValue.getUserObject();
                    return folderValue.getDisplayName();
                }
                return value.toString();
            }
        };
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(renderer.getDefaultClosedIcon());
        folderTree.setCellRenderer(renderer);
        folderTree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)folderTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (node.getUserObject() instanceof PSTFolder) {
                PSTFolder folderValue = (PSTFolder)node.getUserObject();
                try {
                    this.selectFolder(folderValue);
                }
                catch (Exception err) {
                    System.out.println("unable to change folder");
                    err.printStackTrace();
                }
            }
        });
        JScrollPane treePane = new JScrollPane(folderTree);
        JScrollPane emailTablePanel = null;
        try {
            this.emailTableModel = new EmailTableModel(this.pstFile.getRootFolder(), this.pstFile);
            JTable emailTable = new JTable(this.emailTableModel);
            emailTable.setAutoCreateRowSorter(true);
            emailTablePanel = new JScrollPane(emailTable);
            emailTable.setFillsViewportHeight(true);
            ListSelectionModel selectionModel = emailTable.getSelectionModel();
            selectionModel.addListSelectionListener(e -> {
                JTable source = emailTable;
                this.selectedMessage = this.emailTableModel.getMessageAtRow(source.convertRowIndexToModel(source.getSelectedRow()));
                if (this.selectedMessage instanceof PSTContact) {
                    PSTContact contact = (PSTContact)this.selectedMessage;
                    this.emailText.setText(contact.toString());
                } else if (this.selectedMessage instanceof PSTAppointment) {
                    PSTAppointment task = (PSTAppointment)this.selectedMessage;
                    this.emailText.setText(task.toString());
                } else if (this.selectedMessage instanceof PSTTask) {
                    PSTTask task = (PSTTask)this.selectedMessage;
                    this.emailText.setText(task.toString());
                } else if (this.selectedMessage instanceof PSTActivity) {
                    PSTActivity journalEntry = (PSTActivity)this.selectedMessage;
                    this.emailText.setText(journalEntry.toString());
                } else if (this.selectedMessage instanceof PSTRss) {
                    PSTRss rss = (PSTRss)this.selectedMessage;
                    this.emailText.setText(rss.toString());
                } else if (this.selectedMessage != null) {
                    this.emailText.setText(this.selectedMessage.getBody());
                }
                this.setAttachmentText();
                this.emailText.setCaretPosition(0);
            });
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.f.setJMenuBar(this.createMenu());
        this.emailText = new JTextPane();
        this.emailText.setFont(new Font("Monospaced", 0, 12));
        this.emailPanel = new JPanel(new BorderLayout());
        this.attachPanel = new JPanel(new BorderLayout());
        this.attachLabel = new JLabel("Attachments:");
        this.attachText = new JTextField("");
        this.attachText.setEditable(false);
        this.attachPanel.add((Component)this.attachLabel, "West");
        this.attachPanel.add((Component)this.attachText, "Center");
        this.emailPanel.add((Component)this.attachPanel, "North");
        this.emailPanel.add((Component)this.emailText, "Center");
        JSplitPane emailSplitPane = new JSplitPane(0, emailTablePanel, new JScrollPane(this.emailPanel));
        emailSplitPane.setOneTouchExpandable(true);
        emailSplitPane.setDividerLocation(0.25);
        JSplitPane primaryPane = new JSplitPane(1, treePane, emailSplitPane);
        primaryPane.setOneTouchExpandable(true);
        primaryPane.setDividerLocation(0.3);
        this.f.add(primaryPane);
        this.f.setDefaultCloseOperation(2);
        this.f.setVisible(true);
        this.f.setExtendedState(this.f.getExtendedState() | 6);
    }

    private void buildTree(DefaultMutableTreeNode top, PSTFolder theFolder) {
        try {
            Vector<PSTFolder> children = theFolder.getSubFolders();
            for (PSTFolder folder : children) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(folder);
                if (folder.getSubFolders().size() > 0) {
                    this.buildTree(node, folder);
                }
                top.add(node);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
    }

    void setAttachmentText() {
        StringBuffer s = new StringBuffer();
        try {
            if (this.selectedMessage != null) {
                int numAttach = this.selectedMessage.getNumberOfAttachments();
                for (int x = 0; x < numAttach; ++x) {
                    PSTAttachment attach = this.selectedMessage.getAttachment(x);
                    String filename = attach.getLongFilename();
                    if (filename.isEmpty()) {
                        filename = attach.getFilename();
                    }
                    if (filename.isEmpty()) continue;
                    if (x != 0) {
                        s.append(", ");
                    }
                    s.append(filename);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.attachText.setText(s.toString());
    }

    void selectFolder(PSTFolder folder) throws IOException, PSTException {
        this.emailTableModel.setFolder(folder);
    }

    public JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Save Attachments", 83);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText() == "Save Attachments") {
            this.saveAttachments();
        }
    }

    private void saveAttachments() {
        if (this.selectedMessage != null) {
            int numAttach = this.selectedMessage.getNumberOfAttachments();
            if (numAttach == 0) {
                JOptionPane.showMessageDialog(this.f, "Email has no attachments");
                return;
            }
            try {
                for (int x = 0; x < numAttach; ++x) {
                    PSTAttachment attach = this.selectedMessage.getAttachment(x);
                    InputStream attachmentStream = attach.getFileInputStream();
                    String filename = attach.getLongFilename();
                    if (filename.isEmpty()) {
                        filename = attach.getFilename();
                    }
                    JFileChooser chooser = new JFileChooser();
                    chooser.setSelectedFile(new File(filename));
                    int r = chooser.showSaveDialog(this.f);
                    if (r == 0) {
                        int count;
                        FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
                        int bufferSize = 8176;
                        byte[] buffer = new byte[8176];
                        do {
                            count = attachmentStream.read(buffer);
                            out.write(buffer, 0, count);
                        } while (count == 8176);
                        out.close();
                    }
                    attachmentStream.close();
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.f, "Failed writing to file");
            }
            catch (PSTException pste) {
                JOptionPane.showMessageDialog(this.f, "Error in PST file");
            }
        }
    }

    public static void main(String[] args) throws PSTException, IOException {
        new TestGui(args[0]);
    }
}

