/*
 * Decompiled with CFR 0.152.
 */
package example;

import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import java.io.IOException;
import java.util.Vector;

public class Test {
    int depth = -1;

    public static void main(String[] args) {
        new Test(args[0]);
    }

    public Test(String filename) {
        try {
            PSTFile pstFile = new PSTFile(filename);
            System.out.println(pstFile.getMessageStore().getDisplayName());
            this.processFolder(pstFile.getRootFolder());
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void processFolder(PSTFolder folder) throws PSTException, IOException {
        ++this.depth;
        if (this.depth > 0) {
            this.printDepth();
            System.out.println(folder.getDisplayName());
        }
        if (folder.hasSubfolders()) {
            Vector<PSTFolder> childFolders = folder.getSubFolders();
            for (PSTFolder childFolder : childFolders) {
                this.processFolder(childFolder);
            }
        }
        if (folder.getContentCount() > 0) {
            ++this.depth;
            PSTMessage email = (PSTMessage)folder.getNextChild();
            while (email != null) {
                if (!email.getMessageClass().equals("IPM.Note")) {
                    this.printDepth();
                    System.out.println("Email: [" + email.getMessageClass() + "]" + email.getDescriptorNodeId() + " - " + email.getSubject());
                }
                email = (PSTMessage)folder.getNextChild();
            }
            --this.depth;
        }
        --this.depth;
    }

    public void printDepth() {
        for (int x = 0; x < this.depth - 1; ++x) {
            System.out.print(" | ");
        }
        System.out.print(" |- ");
    }
}

