/*
 * Decompiled with CFR 0.152.
 */
package example;

import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

class EmailTableModel
extends AbstractTableModel {
    PSTFolder theFolder = null;
    ArrayList<PSTMessage> theFolderMessageList;
    PSTFile theFile = null;
    HashMap cache = new HashMap();
    String[] columnNames = new String[]{"Descriptor ID", "MessageClass", "Subject", "From", "To", "Date", "Has Attachments"};
    String[][] rowData = new String[][]{{"", "", "", "", ""}};
    int rowCount = 0;

    public EmailTableModel(PSTFolder theFolder, PSTFile theFile) {
        this.theFolder = theFolder;
        this.theFile = theFile;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        try {
            return this.theFolder.getContentCount();
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(0);
            return 0;
        }
    }

    public PSTMessage getMessageAtRow(int row) {
        PSTMessage next = null;
        try {
            if (this.cache.containsKey(this.theFolder + this.toString() + " - " + row)) {
                next = (PSTMessage)this.cache.get(this.theFolder + this.toString() + " - " + row);
            } else {
                this.theFolder.moveChildCursorTo(row);
                next = (PSTMessage)this.theFolder.getNextChild();
                this.cache.put(this.theFolder + this.toString() + " - " + row, next);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return next;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            PSTMessage next = this.getMessageAtRow(row);
            if (next == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return "" + next.getDescriptorNode().descriptorIdentifier;
                }
                case 1: {
                    return next.getMessageClass();
                }
                case 2: {
                    return next.getSubject();
                }
                case 3: {
                    return next.getSentRepresentingName() + " <" + next.getSentRepresentingEmailAddress() + ">";
                }
                case 4: {
                    return next.getReceivedByName() + " <" + next.getReceivedByAddress() + ">" + next.getDisplayTo();
                }
                case 5: {
                    return next.getClientSubmitTime();
                }
                case 6: {
                    return next.hasAttachments() ? "Yes" : "No";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public void setFolder(PSTFolder theFolder) throws PSTException, IOException {
        theFolder.moveChildCursorTo(0);
        this.theFolder = theFolder;
        this.fireTableDataChanged();
    }
}

