/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.byteseek.compiler.CompileException;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.regex.RegexParser;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.ByteNode;
import net.byteseek.parser.tree.node.ChildrenNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceAnchor;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceCompiler;
import uk.gov.nationalarchives.droid.core.signature.compiler.SignatureType;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.SideFragment;
import uk.gov.nationalarchives.droid.core.signature.droid6.SubSequence;
import uk.gov.nationalarchives.droid.core.signature.xml.XmlUtils;

public final class ByteSequenceSerializer {
    public static final ByteSequenceSerializer SERIALIZER = new ByteSequenceSerializer();
    private static final String SEQUENCE = "Sequence";
    private static final RegexParser PARSER = new RegexParser();
    private static final String REFERENCE = "Reference";
    private static final String BYTE_SEQUENCE = "ByteSequence";
    private static final String LEFT_FRAGMENT = "LeftFragment";
    private static final String RIGHT_FRAGMENT = "RightFragment";
    private static final String POSITION = "Position";
    private static final String MIN_OFFSET = "MinOffset";
    private static final String MAX_OFFSET = "MaxOffset";
    private static final String SUB_SEQUENCE = "SubSequence";
    private static final String SUB_SEQ_MIN_OFFSET = "SubSeqMinOffset";
    private static final String SUB_SEQ_MAX_OFFSET = "SubSeqMaxOffset";
    private static final String HEXDIGITS = "%02x";

    public String toXML(String sequence, ByteSequenceAnchor anchor, ByteSequenceCompiler.CompileType compileType, SignatureType sigType) throws CompileException {
        return this.toXML(ByteSequenceCompiler.COMPILER.compile(sequence, anchor, compileType), sigType);
    }

    public String toXML(ByteSequence sequence, SignatureType sigType) throws CompileException {
        Document doc = this.getXMLDocument();
        Element byteSequence = this.createByteSequenceElement(doc, sequence);
        int position = 1;
        for (SubSequence sub : sequence.getSubSequences()) {
            try {
                byteSequence.appendChild(this.createSubSequenceElement(doc, sub, sigType, position++));
            }
            catch (ParseException e) {
                throw new CompileException(e.getMessage(), e);
            }
        }
        try {
            return XmlUtils.toXmlString(doc, false);
        }
        catch (TransformerException e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    public String toPRONOMExpression(String expression, SignatureType sigType, boolean spaceElements) throws CompileException {
        return this.toPRONOMExpression(ByteSequenceCompiler.COMPILER.compile(expression), sigType, spaceElements);
    }

    public String toPRONOMExpression(String expression, SignatureType sigType, ByteSequenceAnchor anchorType, boolean spaceElements) throws CompileException {
        return this.toPRONOMExpression(ByteSequenceCompiler.COMPILER.compile(expression, anchorType), sigType, spaceElements);
    }

    public String toPRONOMExpression(ByteSequence sequence, SignatureType sigType, boolean spaceElements) throws CompileException {
        try {
            String byteseekRegex = sequence.toRegularExpression(true);
            ParseTree parsed = PARSER.parse(byteseekRegex);
            return this.toPRONOMExpression(parsed, sigType, spaceElements);
        }
        catch (ParseException e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    private Document getXMLDocument() {
        DocumentBuilder dBuilder;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return dBuilder.newDocument();
    }

    private Element createByteSequenceElement(Document doc, ByteSequence sequence) {
        Element byteSequence = doc.createElement(BYTE_SEQUENCE);
        byteSequence.setAttribute(REFERENCE, sequence.getReference());
        if (!sequence.getSequence().isEmpty()) {
            byteSequence.setAttribute(SEQUENCE, sequence.getSequence());
        }
        doc.appendChild(byteSequence);
        return byteSequence;
    }

    private Element createSubSequenceElement(Document doc, SubSequence sub, SignatureType sigType, int position) throws ParseException {
        Element subSequence = this.createBasicSubSequenceElement(doc, sub, sigType, position);
        this.appendFragments(doc, subSequence, sub.getLeftFragments(), LEFT_FRAGMENT, sigType);
        this.appendFragments(doc, subSequence, sub.getRightFragments(), RIGHT_FRAGMENT, sigType);
        return subSequence;
    }

    private void appendFragments(Document doc, Element subsequence, List<List<SideFragment>> fragments, String elementName, SignatureType sigType) throws ParseException {
        int fragPos = 0;
        for (List<SideFragment> fragsAtPos : fragments) {
            ++fragPos;
            for (SideFragment frag : fragsAtPos) {
                Element fragment = doc.createElement(elementName);
                fragment.setAttribute(POSITION, Integer.toString(fragPos));
                fragment.setAttribute(MIN_OFFSET, Integer.toString(frag.getMinOffset()));
                fragment.setAttribute(MAX_OFFSET, Integer.toString(frag.getMaxOffset()));
                fragment.setTextContent(this.getSequenceMatcherExpression(frag.getMatcher(), sigType));
                subsequence.appendChild(fragment);
            }
        }
    }

    private Element createBasicSubSequenceElement(Document doc, SubSequence sub, SignatureType sigType, int position) throws ParseException {
        Element subSequence = doc.createElement(SUB_SEQUENCE);
        subSequence.setAttribute(POSITION, Integer.toString(position));
        subSequence.setAttribute(SUB_SEQ_MIN_OFFSET, Integer.toString(sub.getMinSeqOffset()));
        subSequence.setAttribute(SUB_SEQ_MAX_OFFSET, Integer.toString(sub.getMaxSeqOffset()));
        Element seq = doc.createElement(SEQUENCE);
        seq.setTextContent(this.getSequenceMatcherExpression(sub.getAnchorMatcher(), sigType));
        subSequence.appendChild(seq);
        return subSequence;
    }

    private String getSequenceMatcherExpression(SequenceMatcher matcher, SignatureType sigType) throws ParseException {
        String byteseekExpression = matcher.toRegularExpression(true);
        ParseTree parsed = PARSER.parse(byteseekExpression);
        return this.toPRONOMExpression(parsed, sigType, false);
    }

    private String toPRONOMExpression(ParseTree tree, SignatureType sigType, boolean spaceElements) throws ParseException {
        StringBuilder builder = new StringBuilder();
        this.toPRONOMExpression(tree, builder, sigType, spaceElements, false, false);
        return builder.toString();
    }

    private void toPRONOMExpression(ParseTree tree, StringBuilder builder, SignatureType sigType, boolean spaceElements, boolean inSet, boolean inAlternatives) throws ParseException {
        switch (tree.getParseTreeType()) {
            case BYTE: {
                if (tree.isValueInverted()) {
                    builder.append("[!").append(String.format(HEXDIGITS, tree.getByteValue() & 0xFF).toUpperCase()).append(']');
                    break;
                }
                builder.append(String.format(HEXDIGITS, tree.getByteValue() & 0xFF).toUpperCase());
                break;
            }
            case STRING: {
                String value = tree.getTextValue();
                if (sigType == SignatureType.CONTAINER) {
                    builder.append('\'').append(value).append('\'');
                    break;
                }
                for (int i = 0; i < value.length(); ++i) {
                    char theChar = value.charAt(i);
                    builder.append(String.format(HEXDIGITS, theChar).toUpperCase());
                    if (!spaceElements || i + 1 >= value.length()) continue;
                    builder.append(' ');
                }
                break;
            }
            case RANGE: {
                if (!inSet) {
                    builder.append('[');
                    if (tree.isValueInverted()) {
                        builder.append('!');
                    }
                }
                this.appendByteValue(tree.getChild(0).getIntValue(), sigType == SignatureType.CONTAINER, builder);
                builder.append(':');
                this.appendByteValue(tree.getChild(1).getIntValue(), sigType == SignatureType.CONTAINER, builder);
                if (inSet) break;
                builder.append(']');
                break;
            }
            case ANY: {
                builder.append("??");
                break;
            }
            case ALL_BITMASK: {
                if (!inSet) {
                    builder.append('[');
                    if (tree.isValueInverted()) {
                        builder.append('!');
                    }
                }
                builder.append('&').append(String.format(HEXDIGITS, tree.getByteValue() & 0xFF).toUpperCase());
                if (inSet) break;
                builder.append(']');
                break;
            }
            case REPEAT: {
                int repeatNum = tree.getChild(0).getIntValue();
                if (repeatNum == 1) {
                    builder.append("??");
                    break;
                }
                builder.append('{').append(repeatNum).append('}');
                break;
            }
            case REPEAT_MIN_TO_MANY: {
                builder.append('{').append(tree.getChild(0).getIntValue()).append("-*}");
                break;
            }
            case REPEAT_MIN_TO_MAX: {
                builder.append('{').append(tree.getChild(0).getIntValue()).append('-').append(tree.getChild(1).getIntValue()).append('}');
                break;
            }
            case SET: {
                ParseTree alternativeSet = this.detectAlternativeSetRanges(tree, sigType);
                if (alternativeSet != null) {
                    this.toPRONOMExpression(alternativeSet, builder, sigType, spaceElements, false, inAlternatives);
                    break;
                }
                if (sigType == SignatureType.BINARY && this.allChildrenAreSingleBytes(tree)) {
                    this.appendAlternatives(tree, builder, sigType, spaceElements, true, inAlternatives);
                    break;
                }
                if (!inSet) {
                    builder.append('[');
                    if (tree.isValueInverted()) {
                        builder.append('!');
                    }
                }
                for (int i = 0; i < tree.getNumChildren(); ++i) {
                    if (spaceElements && i > 0) {
                        builder.append(' ');
                    }
                    this.toPRONOMExpression(tree.getChild(i), builder, sigType, spaceElements, true, inAlternatives);
                }
                if (inSet) break;
                builder.append(']');
                break;
            }
            case ALTERNATIVES: {
                this.appendAlternatives(tree, builder, sigType, spaceElements, false, inAlternatives);
                break;
            }
            case SEQUENCE: {
                for (int i = 0; i < tree.getNumChildren(); ++i) {
                    if (spaceElements && i > 0) {
                        builder.append(' ');
                    }
                    this.toPRONOMExpression(tree.getChild(i), builder, sigType, spaceElements, inSet, inAlternatives);
                }
                break;
            }
            case ZERO_TO_MANY: {
                builder.append('*');
                break;
            }
            default: {
                throw new ParseException("Encountered an unknown node type: " + tree);
            }
        }
    }

    private ParseTree detectAlternativeSetRanges(ParseTree node, SignatureType sigType) throws ParseException {
        int numChildren = node.getNumChildren();
        if (numChildren > 16) {
            BitSet bitset = new BitSet(256);
            int minPos = 256;
            int maxPos = -1;
            for (int i = 0; i < numChildren; ++i) {
                ParseTree child = node.getChild(i);
                if (child.getParseTreeType() != ParseTreeType.BYTE) {
                    return null;
                }
                int byteValue = child.getIntValue();
                minPos = Math.min(byteValue, minPos);
                maxPos = Math.max(byteValue, maxPos);
                bitset.set(byteValue);
            }
            ArrayList<Integer> startRangePos = new ArrayList<Integer>();
            ArrayList<Integer> endRangePos = new ArrayList<Integer>();
            boolean lastBitSet = false;
            int startPos = -1;
            for (int bitPos = minPos; bitPos < maxPos; ++bitPos) {
                if (bitset.get(bitPos)) {
                    if (!lastBitSet) {
                        startPos = bitPos;
                    }
                    lastBitSet = true;
                    continue;
                }
                if (lastBitSet) {
                    int length = bitPos - startPos;
                    if (length < 4) {
                        return null;
                    }
                    if (startRangePos.size() > 4) {
                        return null;
                    }
                    startRangePos.add(startPos);
                    endRangePos.add(bitPos - 1);
                    startPos = -1;
                }
                lastBitSet = false;
            }
            if (lastBitSet) {
                startRangePos.add(startPos);
                endRangePos.add(maxPos);
            }
            ArrayList<ParseTree> rangeChildren = new ArrayList<ParseTree>();
            for (int i = 0; i < startRangePos.size(); ++i) {
                ByteNode rangeStart = new ByteNode((byte)((Integer)startRangePos.get(i)).intValue());
                ByteNode rangeEnd = new ByteNode((byte)((Integer)endRangePos.get(i)).intValue());
                ChildrenNode rangeNode = new ChildrenNode(ParseTreeType.RANGE, rangeStart, rangeEnd);
                rangeChildren.add(rangeNode);
            }
            ParseTreeType nodeType = sigType == SignatureType.BINARY ? ParseTreeType.ALTERNATIVES : ParseTreeType.SET;
            return new ChildrenNode(nodeType, rangeChildren);
        }
        return null;
    }

    private void appendAlternatives(ParseTree alternatives, StringBuilder builder, SignatureType sigType, boolean spaceElements, boolean inSet, boolean inAlternatives) throws ParseException {
        if (!inAlternatives) {
            builder.append('(');
        }
        for (int i = 0; i < alternatives.getNumChildren(); ++i) {
            if (i > 0) {
                this.appendAlternativePipe(builder, spaceElements);
            }
            ParseTree alternative = alternatives.getChild(i);
            if (inSet && alternative.getParseTreeType() == ParseTreeType.STRING) {
                this.appendStringAsAlternativeBytes(builder, alternative.getTextValue(), spaceElements);
                continue;
            }
            this.toPRONOMExpression(alternatives.getChild(i), builder, sigType, spaceElements, false, true);
        }
        if (!inAlternatives) {
            builder.append(')');
        }
    }

    private void appendStringAsAlternativeBytes(StringBuilder builder, String value, boolean spaceElements) throws ParseException {
        for (int charIndex = 0; charIndex < value.length(); ++charIndex) {
            char theChar;
            if (charIndex > 0) {
                this.appendAlternativePipe(builder, spaceElements);
            }
            if ((theChar = value.charAt(charIndex)) > '\u00ff') {
                throw new ParseException("Could not process a char in a string with a value higher than 255: " + theChar);
            }
            builder.append(String.format(HEXDIGITS, theChar));
        }
    }

    private void appendAlternativePipe(StringBuilder builder, boolean spaceElements) {
        if (spaceElements) {
            builder.append(' ');
        }
        builder.append('|');
        if (spaceElements) {
            builder.append(' ');
        }
    }

    private boolean allChildrenAreSingleBytes(ParseTree node) {
        block3: for (int i = 0; i < node.getNumChildren(); ++i) {
            ParseTree child = node.getChild(i);
            switch (child.getParseTreeType()) {
                case BYTE: 
                case STRING: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void appendByteValue(int value, boolean prettyPrint, StringBuilder builder) {
        if (prettyPrint && value >= 32 && value <= 126) {
            builder.append('\'').append((char)value).append('\'');
        } else {
            builder.append(String.format(HEXDIGITS, value).toUpperCase());
        }
    }
}

