/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.byteseek.io.reader.InputStreamReader;
import net.byteseek.io.reader.cache.DoubleCache;
import net.byteseek.io.reader.cache.LeastRecentlyUsedCache;
import net.byteseek.io.reader.cache.TempFileCache;
import net.byteseek.io.reader.cache.TopAndTailStreamCache;
import net.byteseek.io.reader.cache.TwoLevelCache;
import net.byteseek.io.reader.cache.WindowCache;
import org.apache.commons.io.FilenameUtils;

public final class ResourceUtils {
    public static final double FREE_MEMORY_THRESHOLD = 6.7108864E7;
    private static final int BUFFER_SIZE = 8192;
    private static final int NINENTYEIGHT = 98;
    private static final int THIRTYTHREE = 33;
    private static final int NINENTYFOUR = 94;
    private static final int HEX_F = 15;
    private static final int HEX_7F = 127;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_4 = 4;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_11 = 11;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_18 = 18;
    private static final int UNSIGNED_RIGHT_SHIFT_BY_25 = 25;
    private static final int ARRAYLENGTH = 5;

    private ResourceUtils() {
        throw new UnsupportedOperationException("ExtensionUtils is a static utility class and cannot be constructed.");
    }

    public static String getExtension(String filename) {
        int queryPos = filename.indexOf(63);
        String bareFilename = queryPos > -1 ? filename.substring(0, queryPos) : filename;
        String nameOnly = FilenameUtils.getName(bareFilename);
        int dotPos = nameOnly.lastIndexOf(46);
        return dotPos > 0 ? nameOnly.substring(dotPos + 1) : "";
    }

    public static InputStreamReader getStreamReader(InputStream in, Path tempDir, int topTailCapacity) {
        InputStreamReader reader;
        if ((double)Runtime.getRuntime().freeMemory() > 6.7108864E7) {
            TwoLevelCache cache = TwoLevelCache.create(new TopAndTailStreamCache(topTailCapacity), new TempFileCache(tempDir == null ? null : tempDir.toFile()));
            reader = new InputStreamReader(in, (WindowCache)cache);
        } else {
            LeastRecentlyUsedCache memoryCache = new LeastRecentlyUsedCache(1024);
            TempFileCache persistentCache = new TempFileCache(tempDir == null ? null : tempDir.toFile());
            DoubleCache cache = DoubleCache.create(memoryCache, persistentCache);
            reader = new InputStreamReader(in, (WindowCache)cache);
            reader.setSoftWindowRecovery(persistentCache);
        }
        return reader;
    }

    public static InputStreamReader getStreamReader(InputStream in, Path tempDir, int topTailCapacity, boolean closeStream) {
        InputStreamReader reader;
        if ((double)Runtime.getRuntime().freeMemory() > 6.7108864E7) {
            TwoLevelCache cache = TwoLevelCache.create(new TopAndTailStreamCache(topTailCapacity), new TempFileCache(tempDir == null ? null : tempDir.toFile()));
            reader = new InputStreamReader(in, cache, closeStream);
        } else {
            LeastRecentlyUsedCache memoryCache = new LeastRecentlyUsedCache(1024);
            TempFileCache persistentCache = new TempFileCache(tempDir == null ? null : tempDir.toFile());
            DoubleCache cache = DoubleCache.create(memoryCache, persistentCache);
            reader = new InputStreamReader(in, cache, closeStream);
            reader.setSoftWindowRecovery(persistentCache);
        }
        return reader;
    }

    public static Path createTemporaryFileFromStream(Path tempDir, InputStream stream) throws IOException {
        Path tempFile = Files.createTempFile(tempDir, "droid-temp~", null, new FileAttribute[0]);
        try {
            Files.copy(stream, tempFile, new CopyOption[0]);
            return tempFile;
        }
        catch (IOException ex) {
            Files.deleteIfExists(tempFile);
            throw ex;
        }
    }

    public static int readBuffer(InputStream in, byte[] buffer) throws IOException {
        int totalBytesRead;
        int numRead;
        int bytesToRead = buffer.length;
        for (totalBytesRead = 0; totalBytesRead < bytesToRead && (numRead = in.read(buffer, totalBytesRead, bytesToRead - totalBytesRead)) != -1; totalBytesRead += numRead) {
        }
        return totalBytesRead;
    }

    public static int readBuffer(RandomAccessFile file, byte[] buffer) throws IOException {
        int totalBytesRead;
        int numRead;
        int bytesToRead = buffer.length;
        for (totalBytesRead = 0; totalBytesRead < bytesToRead && (numRead = file.read(buffer, totalBytesRead, bytesToRead - totalBytesRead)) != -1; totalBytesRead += numRead) {
        }
        return totalBytesRead;
    }

    private static long printableValue(long value) {
        return value < 94L ? value + 33L : value + 98L;
    }

    public static String getBase128Integer(long value) {
        char[] values = new char[5];
        int i = 0;
        values[i++] = (char)ResourceUtils.printableValue(value >>> 25 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 18 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 11 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 4 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value & 0xFL);
        return new String(values);
    }

    public static void getBase128IntegerCharArray(long value, char[] values) {
        int i = 0;
        values[i++] = (char)ResourceUtils.printableValue(value >>> 25 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 18 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 11 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value >>> 4 & 0x7FL);
        values[i++] = (char)ResourceUtils.printableValue(value & 0xFL);
    }

    public static void attemptToDeleteTempFiles(Path tempDir) {
        FileFilter tmpFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && FilenameUtils.isExtension(f.getName(), "tmp");
            }
        };
        if (tempDir != null) {
            File[] files;
            for (File file : files = tempDir.toFile().listFiles(tmpFileFilter)) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }
}

