/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jwat.warc.WarcHeader;
import org.jwat.warc.WarcReader;
import org.jwat.warc.WarcReaderFactory;
import org.jwat.warc.WarcRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveInputStreamIterator;
import uk.gov.nationalarchives.droid.core.interfaces.archive.WebArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class WarcArchiveHandler
extends WebArchiveHandler
implements ArchiveHandler {
    protected static final String WEB_ARCHIVE_TYPE = "warc";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(IdentificationRequest request) throws IOException {
        try (final InputStream arcIn = request.getSourceInputStream();){
            Iterable<WarcRecord> iterable = new Iterable<WarcRecord>(){

                @Override
                public Iterator<WarcRecord> iterator() {
                    return new WarcArchiveEntryIterator(arcIn);
                }
            };
            WarcArchiveWalker walker = new WarcArchiveWalker(request.getIdentifier(), arcIn);
            walker.walk(iterable);
        }
    }

    final void submit(WarcRecord entry, String entryName, URI parentName, InputStream in, ResourceId correlationId, long originatorNodeId) throws IOException {
        WarcHeader header = entry.header;
        long size = header.contentLength;
        Date time = header.warcDate;
        RequestMetaData metaData = new RequestMetaData(size == -1L ? null : Long.valueOf(size), time == null ? null : Long.valueOf(time.getTime()), entryName);
        super.submit(WEB_ARCHIVE_TYPE, metaData, parentName, entry.getPayloadContent(), correlationId, originatorNodeId);
    }

    private final class WarcArchiveWalker
    extends ArchiveFileWalker<WarcRecord> {
        private final ResourceId parentId;
        private final long originatorNodeId;
        private final URI parentName;
        private final InputStream in;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();

        WarcArchiveWalker(RequestIdentifier parent, InputStream in) {
            this.in = in;
            this.parentId = parent.getResourceId();
            this.parentName = parent.getUri();
            this.originatorNodeId = parent.getAncestorId();
        }

        @Override
        protected void handleEntry(WarcRecord entry) throws IOException {
            int maxLEN = 4095;
            String entryUri = entry.header.warcTargetUriStr;
            String entryPath = new URL(entryUri).getFile();
            int queryPos = entryPath.indexOf(63);
            String querylessPath = queryPos > 0 ? entryPath.substring(0, queryPos) : entryPath;
            String entryName = entryPath.substring(querylessPath.lastIndexOf(47) + 1);
            String prefixPath = entryUri.substring(0, entryUri.length() - entryName.length());
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = WarcArchiveHandler.this.processAncestorFolders(WarcArchiveHandler.WEB_ARCHIVE_TYPE, prefixPath, entryUri, this.parentId, this.parentName, this.directories);
            }
            String truncatedName = entryName.length() < 4095 ? entryName : entryName.substring(0, 4095);
            WarcArchiveHandler.this.submit(entry, truncatedName, this.parentName, this.in, correlationId, this.originatorNodeId);
        }
    }

    private final class WarcArchiveEntryIterator
    extends ArchiveInputStreamIterator<WarcRecord, InputStream> {
        private Iterator<WarcRecord> iterator;

        WarcArchiveEntryIterator(InputStream in) {
            super(in);
            try {
                WarcReader warcReader = WarcReaderFactory.getReader(in);
                this.iterator = warcReader.iterator();
            }
            catch (IOException e) {
                WarcArchiveHandler.this.log.error(e.getMessage(), e);
                System.err.println(e);
            }
        }

        @Override
        protected WarcRecord getNextEntry() throws IOException {
            WarcRecord record = null;
            if (this.iterator.hasNext()) {
                record = this.iterator.next();
                while (!(record == null || "response".equals(record.header.warcTypeStr) && record.getHttpHeader() != null && 200 == record.getHttpHeader().statusCode)) {
                    if (this.iterator.hasNext()) {
                        record = this.iterator.next();
                        continue;
                    }
                    record = null;
                }
            }
            return record;
        }
    }
}

