/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.SevenZipArchiveHandler;

public class SevenZipIteratorAdapter
implements Iterable<SevenZipArchiveHandler.SevenZEntryInfo> {
    private static final int BYTE_TO_INT = 255;
    private final SevenZFile zipFile;

    public SevenZipIteratorAdapter(SevenZFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public Iterator<SevenZipArchiveHandler.SevenZEntryInfo> iterator() {
        return new SevenZipIterator();
    }

    private class SevenZipEntryStream
    extends InputStream {
        private final byte[] oneByte = new byte[1];

        private SevenZipEntryStream() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return SevenZipIteratorAdapter.this.zipFile.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            byte[] aByte = this.oneByte;
            int bytesRead = this.read(aByte, 0, 1);
            return bytesRead < 1 ? -1 : aByte[0] & 0xFF;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class SevenZipIterator
    implements Iterator<SevenZipArchiveHandler.SevenZEntryInfo> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final InputStream stream = new SevenZipEntryStream();
        private SevenZArchiveEntry entry;

        private SevenZipIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.entry == null) {
                try {
                    this.entry = SevenZipIteratorAdapter.this.zipFile.getNextEntry();
                }
                catch (IOException e) {
                    this.log.error("Exception thrown when walking 7zip archive: " + SevenZipIteratorAdapter.this.zipFile, e);
                }
            }
            return this.entry != null;
        }

        @Override
        public SevenZipArchiveHandler.SevenZEntryInfo next() {
            if (this.hasNext()) {
                SevenZipArchiveHandler.SevenZEntryInfo info = new SevenZipArchiveHandler.SevenZEntryInfo(this.entry, this.stream);
                this.entry = null;
                return info;
            }
            this.log.error("No more entries in the seven zip archive: " + SevenZipIteratorAdapter.this.zipFile);
            throw new NoSuchElementException();
        }
    }
}

