/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.archive.RarReader;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public final class RarArchiveHandler
implements ArchiveHandler {
    private static final String UNIX_PATH_SPLITTER = "/";
    private static final String WINDOWS_PATH_SPLITTER = "\\";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResultHandler resultHandler;
    private AsynchDroid droid;
    private IdentificationRequestFactory<InputStream> identificationRequestFactory;

    public RarArchiveHandler() {
    }

    public RarArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler) {
        this.droid = droidCore;
        this.identificationRequestFactory = factory;
        this.resultHandler = resultHandler;
    }

    @Override
    public void handle(IdentificationRequest request) throws IOException {
        RarReader readerVolume = new RarReader(request.getWindowReader());
        try (Archive archive = new Archive(readerVolume, null, null);){
            if (archive.isEncrypted()) {
                throw new RuntimeException("Encrypted archive");
            }
            RarWalker walker = new RarWalker(archive, request.getIdentifier());
            walker.walk(archive.getFileHeaders());
        }
        catch (RarException ex) {
            throw new RuntimeException("Rar processing failed :", ex);
        }
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setDroid(AsynchDroid droid) {
        this.droid = droid;
    }

    public void setIdentificationRequestFactory(IdentificationRequestFactory<InputStream> identificationRequestFactory) {
        this.identificationRequestFactory = identificationRequestFactory;
    }

    private final class RarWalker
    extends ArchiveFileWalker<FileHeader> {
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Archive archive;
        private final ResourceId rootParentId;
        private final URI parentURI;
        private final long originatorNodeId;

        private RarWalker(Archive archive, RequestIdentifier requestIdentifier) {
            this.archive = archive;
            this.parentURI = requestIdentifier.getUri();
            this.originatorNodeId = requestIdentifier.getNodeId();
            this.rootParentId = requestIdentifier.getResourceId();
            this.directories.put("", this.rootParentId);
        }

        private ResourceId submitDirectory(String fullPath, Date mTime) throws URISyntaxException, UnsupportedEncodingException {
            String parentPath = FilenameUtils.getPath(fullPath.substring(0, fullPath.length() - 1));
            String name = FilenameUtils.getName(fullPath.substring(0, fullPath.length() - 1));
            this.log.debug("submitDirectory, processing path: " + parentPath + " name: " + name);
            ResourceId resourceId = this.getFromDirCache(fullPath);
            if (resourceId == null) {
                ResourceId parentID = this.getFromDirCache(parentPath);
                if (parentID == null) {
                    parentID = this.submitDirectory(parentPath, mTime);
                }
                RequestMetaData metaData = new RequestMetaData(null, mTime.getTime(), name);
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toRarUri(this.parentURI, fullPath));
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setRequestMetaData(metaData);
                result.setIdentifier(identifier);
                resourceId = RarArchiveHandler.this.resultHandler.handleDirectory(result, parentID, false);
                this.saveDirToCache(fullPath, resourceId);
            }
            return resourceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submitFile(FileHeader entry) throws IOException, URISyntaxException, RarException {
            String fullpath = entry.getFileNameString();
            String path = FilenameUtils.getPath(fullpath);
            String name = FilenameUtils.getName(fullpath);
            this.log.debug("submitFile, processing path: " + path + " name: " + name);
            ResourceId correlationId = this.getFromDirCache(path);
            if (correlationId == null) {
                correlationId = this.submitDirectory(path, entry.getMTime());
            }
            try (InputStream entryInputStream = null;){
                entryInputStream = this.archive.getInputStream(entry);
                RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toRarUri(this.parentURI, path + name));
                identifier.setAncestorId(this.originatorNodeId);
                identifier.setParentResourceId(correlationId);
                RequestMetaData metaData = new RequestMetaData(entry.getUnpSize(), entry.getMTime().getTime(), name);
                IdentificationRequest<InputStream> request = RarArchiveHandler.this.identificationRequestFactory.newRequest(metaData, identifier);
                if (RarArchiveHandler.this.droid.passesIdentificationFilter(request)) {
                    request.open(entryInputStream);
                    RarArchiveHandler.this.droid.submit(request);
                }
            }
        }

        private void saveDirToCache(String path, ResourceId resourceId) {
            if (path.endsWith(RarArchiveHandler.UNIX_PATH_SPLITTER) || path.endsWith(RarArchiveHandler.WINDOWS_PATH_SPLITTER)) {
                this.directories.put(path.substring(0, path.length() - 1), resourceId);
            } else {
                this.directories.put(path, resourceId);
            }
        }

        private ResourceId getFromDirCache(String path) {
            if (path.endsWith(RarArchiveHandler.UNIX_PATH_SPLITTER) || path.endsWith(RarArchiveHandler.WINDOWS_PATH_SPLITTER)) {
                return this.directories.get(path.substring(0, path.length() - 1));
            }
            return this.directories.get(path);
        }

        @Override
        protected void handleEntry(FileHeader entry) throws IOException {
            try {
                if (entry.isDirectory()) {
                    String path = entry.getFileNameString();
                    if (!path.endsWith(RarArchiveHandler.UNIX_PATH_SPLITTER) && !path.endsWith(RarArchiveHandler.WINDOWS_PATH_SPLITTER)) {
                        path = path + RarArchiveHandler.UNIX_PATH_SPLITTER;
                    }
                    this.submitDirectory(path, entry.getMTime());
                } else {
                    if (entry.isEncrypted()) {
                        throw new RuntimeException("Encrypted entry : " + entry.getFileNameString());
                    }
                    this.submitFile(entry);
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Malformed uri for entry : " + entry.getFileNameString(), ex);
            }
            catch (RarException rarEx) {
                throw new RuntimeException("Probem with RAR extraction : " + entry.getFileNameString(), rarEx);
            }
        }
    }
}

