/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class GZipArchiveHandler
implements ArchiveHandler {
    private IdentificationRequestFactory factory;
    private AsynchDroid droid;

    public GZipArchiveHandler() {
    }

    public GZipArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory factory) {
        this.droid = droidCore;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(IdentificationRequest request) throws IOException {
        boolean submitRequest;
        IdentificationRequest<GZIPInputStream> archiveRequest;
        block9: {
            archiveRequest = null;
            try (InputStream in = request.getSourceInputStream();){
                URI parent = request.getIdentifier().getUri();
                long correlationId = request.getIdentifier().getNodeId();
                URI uri = ArchiveFileUtils.toGZipUri(parent);
                String path = uri.getSchemeSpecificPart();
                String fileName = FilenameUtils.getName(path);
                RequestMetaData metaData = new RequestMetaData(null, null, fileName);
                RequestIdentifier identifier = new RequestIdentifier(uri);
                identifier.setAncestorId(request.getIdentifier().getAncestorId());
                identifier.setParentId(correlationId);
                archiveRequest = this.factory.newRequest(metaData, identifier);
                submitRequest = this.droid.passesIdentificationFilter(archiveRequest);
                if (!submitRequest) break block9;
                try (GZIPInputStream gzin = new GZIPInputStream(in);){
                    archiveRequest.open(gzin);
                }
            }
        }
        if (submitRequest && archiveRequest != null) {
            this.droid.submit(archiveRequest);
        }
    }

    public final void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public final void setDroidCore(AsynchDroid droidCore) {
        this.droid = droidCore;
    }
}

