/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.ReadOnlyException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.byteseek.io.reader.WindowReader;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;

public class FatReader
implements BlockDevice {
    private static final int DEFAULT_SECTOR_SIZE = 512;
    private final WindowReader reader;
    private boolean isClosed;

    public FatReader(WindowReader reader) {
        this.reader = reader;
    }

    @Override
    public long getSize() throws IOException {
        this.ensureOpen();
        return this.reader.length();
    }

    @Override
    public void read(long devOffset, ByteBuffer dest) throws IOException {
        this.ensureOpen();
        int bytesRequested = dest.remaining();
        if (devOffset + (long)bytesRequested > this.reader.length()) {
            throw new EOFException("Reading past end of device");
        }
        ArchiveFileUtils.copyToBuffer(this.reader, devOffset, dest);
    }

    @Override
    public void write(long devOffset, ByteBuffer src) throws ReadOnlyException, IOException, IllegalArgumentException {
        this.ensureOpen();
        throw new ReadOnlyException();
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
    }

    @Override
    public int getSectorSize() throws IOException {
        this.ensureOpen();
        return 512;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.reader + ")";
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Device " + this + " is closed.");
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

