/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

public enum TextEncoding {
    USASCII("US-ASCII", "x-chr/1", "US English encoded text."),
    UTF8("UTF-8", "chr/1", "Unicode variable byte encoded text."),
    UTF16BE("UTF-16BE", "chr/2", "Unicode double byte encoded text, big endian."),
    UTF16LE("UTF-16LE", "chr/3", "Unicode double byte encoded text, little endian."),
    UTF32BE("UTF-32BE", "chr/4", "Unicode four byte encoded text, big endian."),
    UTF32LE("UTF-32LE", "chr/5", "Unicode four byte encoded text, little endian."),
    SHIFT_JIS("SHIFT_JIS", "chr/6", "Shift_JIS encoded Japanese text."),
    ISO2022JP("ISO-2022-JP", "chr/7", "ISO-2022-JP encoded Japanese text."),
    ISO2022CN("ISO-2022-CN", "chr/8", "ISO-2022-CN encoded simplified Chinese text."),
    ISO2022KR("ISO-2022-KR", "chr/9", "ISO-2022-KR encoded Korean text."),
    GB18030("GB18030", "chr/10", "GB18030 encoded Chinese text."),
    EUCJP("EUC-JP", "chr/11", "EUC-JP encoded Japanese text."),
    EUCKR("EUC-KR", "chr/12", "EUC-KR encoded Korean text."),
    Big5("Big5", "chr/13", "Big5 encoded Chinese text."),
    ISO88591("ISO-8859-1", "chr/14", "ISO-8859-1 encoded text for the Danish, Dutch, English,French, German, Italian, Norwegian, Portugese, Swedish languages."),
    ISO88592("ISO-8859-2", "chr/15", "ISO-8859-2 encoded text for the Czech, Hungarian, Polish, Romanian languages."),
    ISO88595("ISO-8859-5", "chr/16", "ISO-8859-5 encoded Russian text."),
    ISO88596("ISO-8859-6", "chr/17", "ISO-8859-6 encoded Arabic text."),
    ISO88597("ISO-8859-7", "chr/18", "ISO-8859-7 encoded Greek text."),
    ISO88598("ISO-8859-8", "chr/19", "ISO-8859-8 encoded Hebrew text."),
    ISO88599("ISO-8859-9", "chr/23", "ISO-8859-9 encoded Turkish text."),
    Windows1251("Windows-1251", "chr/20", "Windows-1251 encoded Russian text."),
    Windows1256("Windows-1256", "chr/21", "Windows-1251 encoded Arabic text."),
    KOI8R("KOI8-R", "chr/22", "KOI8-R encoded Russian text."),
    IBM424rtl("IBM424_rtl", "chr/24", "EBCDIC IBM424 code page encoded Hebrew text, right-to-left."),
    IBM424ltr("IBM424_ltr", "chr/25", "EBCDIC IBM424 code page encoded Hebrew text, left-to-right."),
    IBM420rtl("IBM420_rtl", "chr/26", "EBCDIC IBM420 code page encoded Arabic text, right-to-left."),
    IBM420ltr("IBM420_ltr", "chr/27", "EBCDIC IBM420 code page encoded Arabic text, left-to-right.");

    private String encoding;
    private String puid;
    private String encodingDescription;

    private TextEncoding(String encoding, String puid, String encodingDescription) {
        this.encoding = encoding;
        this.puid = puid;
        this.encodingDescription = encodingDescription;
    }

    public long getId() {
        return this.ordinal();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getPuid() {
        return this.puid;
    }

    public String getEncodingDescription() {
        return this.encodingDescription;
    }
}

