/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class RequestIdentifier {
    @XmlAttribute(name="NodeId")
    private Long nodeId;
    @XmlAttribute(name="Prefix")
    private String prefix;
    @XmlAttribute(name="ParentId")
    private Long parentId;
    @XmlAttribute(name="ParentPrefix")
    private String parentPrefix;
    @XmlAttribute(name="AncestorId")
    private Long ancestorId;
    @XmlValue
    private URI uri;

    RequestIdentifier() {
    }

    public RequestIdentifier(URI uri) {
        this.uri = uri;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setResourceId(ResourceId id) {
        if (id != null) {
            this.nodeId = id.getId();
            this.prefix = id.getPath();
        } else {
            this.nodeId = null;
            this.prefix = "";
        }
    }

    public Long getParentId() {
        return this.parentId;
    }

    public String getParentPrefix() {
        return this.parentPrefix;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setParentPrefix(String parentPrefix) {
        this.parentPrefix = parentPrefix;
    }

    public void setParentResourceId(ResourceId id) {
        if (id != null) {
            this.parentId = id.getId();
            this.parentPrefix = id.getPath();
        } else {
            this.parentId = null;
            this.parentPrefix = "";
        }
    }

    public ResourceId getParentResourceId() {
        return this.parentId == null ? null : new ResourceId(this.parentId, this.parentPrefix);
    }

    public ResourceId getResourceId() {
        return this.nodeId == null ? null : new ResourceId(this.nodeId, this.prefix);
    }

    public Long getAncestorId() {
        return this.ancestorId;
    }

    public void setAncestorId(Long ancestorId) {
        this.ancestorId = ancestorId;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.ancestorId).append(this.nodeId).append(this.prefix).append(this.parentId).append(this.parentPrefix).append(this.uri).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestIdentifier other = (RequestIdentifier)obj;
        return new EqualsBuilder().append(this.ancestorId, other.ancestorId).append(this.nodeId, other.nodeId).append(this.prefix, other.prefix).append(this.parentId, other.parentId).append(this.parentPrefix, other.parentPrefix).append(this.uri, other.uri).isEquals();
    }
}

