/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.filter.BasicFilter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.CriterionOperator;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;

public class IdentificationRequestFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Filter filter;

    public IdentificationRequestFilter() {
        this(null);
    }

    public IdentificationRequestFilter(Filter filter) {
        this.setFilter(filter);
    }

    public boolean passesFilter(IdentificationRequest<?> request) {
        List<FilterCriterion> criteria;
        boolean result = true;
        if (this.filter != null && (criteria = this.filter.getCriteria()).size() > 0) {
            result = this.filter.isNarrowed() ? this.isFilteredNarrowed(request, criteria) : this.isFilteredWidened(request, criteria);
        }
        return result;
    }

    public void setFilter(Filter filter) {
        this.filter = this.createBeforeIdentificationFilter(filter);
    }

    private boolean isFilteredWidened(IdentificationRequest<?> request, List<FilterCriterion> criteria) {
        for (FilterCriterion criterion : criteria) {
            if (!this.meetsCriterion(request, criterion)) continue;
            return true;
        }
        return false;
    }

    private boolean isFilteredNarrowed(IdentificationRequest<?> request, List<FilterCriterion> criteria) {
        for (FilterCriterion criterion : criteria) {
            if (this.meetsCriterion(request, criterion)) continue;
            return false;
        }
        return true;
    }

    private boolean meetsCriterion(IdentificationRequest<?> request, FilterCriterion criterion) {
        boolean result;
        CriterionOperator operator2 = criterion.getOperator();
        Object criterionValue = criterion.getValue();
        switch (criterion.getField()) {
            case FILE_NAME: {
                result = this.compareCaseInsensitiveStrings(request.getRequestMetaData().getName(), operator2, criterionValue);
                break;
            }
            case FILE_SIZE: {
                result = this.compareLongs(request.getRequestMetaData().getSize(), operator2, criterionValue);
                break;
            }
            case LAST_MODIFIED_DATE: {
                result = this.compareDates(request.getRequestMetaData().getTime(), operator2, criterionValue);
                break;
            }
            case FILE_EXTENSION: {
                result = this.compareCaseInsensitiveStrings(request.getExtension(), operator2, criterionValue);
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private boolean compareDates(Long requestTime, CriterionOperator operator2, Object criterionValue) {
        boolean result = false;
        if (requestTime != null) {
            Date requestDate = new LocalDate(requestTime).toDate();
            Date criteriaDate = (Date)criterionValue;
            switch (operator2) {
                case LT: {
                    result = requestDate.before(criteriaDate);
                    break;
                }
                case LTE: {
                    result = requestDate.before(criteriaDate) || requestDate.equals(criteriaDate);
                    break;
                }
                case EQ: {
                    result = requestDate.equals(criteriaDate);
                    break;
                }
                case NE: {
                    result = !requestDate.equals(criteriaDate);
                    break;
                }
                case GT: {
                    result = requestDate.after(criteriaDate);
                    break;
                }
                case GTE: {
                    result = requestDate.after(criteriaDate) || requestDate.equals(criteriaDate);
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean compareLongs(Long nodeValue, CriterionOperator operator2, Object criterionValue) {
        boolean result = false;
        if (nodeValue != null) {
            long compareValue = (Long)criterionValue;
            switch (operator2) {
                case LT: {
                    result = nodeValue.compareTo(compareValue) < 0;
                    break;
                }
                case LTE: {
                    result = nodeValue.compareTo(compareValue) <= 0;
                    break;
                }
                case EQ: {
                    result = nodeValue.compareTo(compareValue) == 0;
                    break;
                }
                case NE: {
                    result = nodeValue.compareTo(compareValue) != 0;
                    break;
                }
                case GT: {
                    result = nodeValue.compareTo(compareValue) > 0;
                    break;
                }
                case GTE: {
                    result = nodeValue.compareTo(compareValue) >= 0;
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean isOperatorInverted(CriterionOperator operator2) {
        return operator2 == CriterionOperator.NE || operator2 == CriterionOperator.NONE_OF || operator2 == CriterionOperator.NOT_STARTS_WITH || operator2 == CriterionOperator.NOT_ENDS_WITH || operator2 == CriterionOperator.NOT_CONTAINS;
    }

    private boolean compareCaseInsensitiveStrings(String nodeValue, CriterionOperator operator2, Object criterionValue) {
        boolean result = false;
        if (nodeValue != null) {
            String nodeValueLower = nodeValue.toLowerCase(Locale.ROOT);
            switch (operator2) {
                case ANY_OF: 
                case NONE_OF: {
                    Object[] values = (Object[])criterionValue;
                    boolean matched = false;
                    for (Object value : values) {
                        String criterionValueLower = ((String)value).toLowerCase(Locale.ROOT);
                        if (!nodeValueLower.equals(criterionValueLower)) continue;
                        matched = true;
                        break;
                    }
                    result = operator2 == CriterionOperator.ANY_OF ? matched : !matched;
                    break;
                }
                default: {
                    String criterionValueLower = ((String)criterionValue).toLowerCase(Locale.ROOT);
                    result = this.compareString(nodeValueLower, operator2, criterionValueLower);
                    break;
                }
            }
        }
        return result;
    }

    private boolean compareString(String nodeValue, CriterionOperator operator2, String compareValue) {
        boolean result = false;
        if (nodeValue != null) {
            switch (operator2) {
                case LT: {
                    result = nodeValue.compareTo(compareValue) < 0;
                    break;
                }
                case LTE: {
                    result = nodeValue.compareTo(compareValue) <= 0;
                    break;
                }
                case EQ: {
                    result = nodeValue.compareTo(compareValue) == 0;
                    break;
                }
                case NE: {
                    result = nodeValue.compareTo(compareValue) != 0;
                    break;
                }
                case GT: {
                    result = nodeValue.compareTo(compareValue) > 0;
                    break;
                }
                case GTE: {
                    result = nodeValue.compareTo(compareValue) >= 0;
                    break;
                }
                case STARTS_WITH: {
                    result = nodeValue.startsWith(compareValue);
                    break;
                }
                case NOT_STARTS_WITH: {
                    result = !nodeValue.startsWith(compareValue);
                    break;
                }
                case ENDS_WITH: {
                    result = nodeValue.endsWith(compareValue);
                    break;
                }
                case NOT_ENDS_WITH: {
                    result = !nodeValue.endsWith(compareValue);
                    break;
                }
                case CONTAINS: {
                    result = nodeValue.contains(compareValue);
                    break;
                }
                case NOT_CONTAINS: {
                    result = !nodeValue.contains(compareValue);
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    private Filter createBeforeIdentificationFilter(Filter identificationFilter) {
        BasicFilter result = null;
        if (identificationFilter != null) {
            List<FilterCriterion> criteria = identificationFilter.getCriteria();
            ArrayList<FilterCriterion> newCriteria = new ArrayList<FilterCriterion>();
            for (FilterCriterion criterion : criteria) {
                switch (criterion.getField()) {
                    case FILE_NAME: 
                    case FILE_SIZE: 
                    case LAST_MODIFIED_DATE: 
                    case FILE_EXTENSION: {
                        newCriteria.add(criterion);
                        break;
                    }
                }
            }
            if (newCriteria.size() > 0) {
                result = new BasicFilter(newCriteria, identificationFilter.isNarrowed());
            } else {
                this.log.warn("No viable file metadata criteria defined - no filtering will be performed.");
            }
        }
        return result;
    }
}

