/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.FileFormatHit;

public class IdentificationRequestByteReaderAdapter
implements ByteReader {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private IdentificationRequest request;
    private long fileMarker;
    private List<FileFormatHit> hits = new ArrayList<FileFormatHit>();

    public IdentificationRequestByteReaderAdapter(IdentificationRequest request) {
        this.request = request;
    }

    @Override
    public final void addHit(FileFormatHit theHit) {
        this.hits.add(theHit);
    }

    @Override
    public final void close() {
        try {
            this.request.close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public final byte[] getbuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte getByte(long fileIndex) {
        try {
            return this.request.getByte(fileIndex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Something went horribly wrong trying to get a byte at position " + fileIndex, ex);
        }
    }

    @Override
    public final int getClassification() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getFileName() {
        return this.request.getFileName();
    }

    @Override
    public final String getFilePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final FileFormatHit getHit(int theIndex) {
        return this.hits.get(theIndex);
    }

    @Override
    public final String getIdentificationWarning() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getNumBytes() {
        return this.request.size();
    }

    @Override
    public final int getNumHits() {
        return this.hits.size();
    }

    @Override
    public final boolean isClassified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void removeHit(int theIndex) {
        this.hits.remove(theIndex);
    }

    @Override
    public final void setErrorIdent() {
    }

    @Override
    public final void setIdentificationWarning(String theWarning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setNoIdent() {
    }

    @Override
    public final void setPositiveIdent() {
    }

    @Override
    public final void setTentativeIdent() {
    }

    @Override
    public final long getFileMarker() {
        return this.fileMarker;
    }

    @Override
    public final void setFileMarker(long fileMarker) {
        this.fileMarker = fileMarker;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.request.getWindowReader();
    }
}

