/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.ole2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.container.AbstractIdentifierEngine;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;

public class Ole2IdentifierEngine
extends AbstractIdentifierEngine {
    private static final String NO_READER_ERROR = "No reader was obtained for %s. This may be due to low memory conditions. Try running with a larger heap size!";
    private final Logger log = LoggerFactory.getLogger(Ole2IdentifierEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(IdentificationRequest request, ContainerSignatureMatchCollection matches) throws IOException {
        InputStream in = null;
        POIFSFileSystem reader = null;
        try {
            block19: {
                if (FileSystemIdentificationRequest.class.isAssignableFrom(request.getClass())) {
                    FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)FileSystemIdentificationRequest.class.cast(request);
                    reader = new POIFSFileSystem(req.getFile().toFile());
                } else {
                    String identifier;
                    try {
                        in = request.getSourceInputStream();
                        reader = new POIFSFileSystem(in);
                        if (reader != null) break block19;
                        identifier = request.getIdentifier() != null ? request.getIdentifier().getUri().toString() : "the current container file";
                    }
                    catch (Throwable throwable) {
                        if (reader == null) {
                            String identifier2 = request.getIdentifier() != null ? request.getIdentifier().getUri().toString() : "the current container file";
                            throw new IOException(String.format(NO_READER_ERROR, identifier2));
                        }
                        throw throwable;
                    }
                    throw new IOException(String.format(NO_READER_ERROR, identifier));
                }
            }
            DirectoryNode root = reader.getRoot();
            OLE2Walker iterator = new OLE2Walker(root, true);
            while (iterator.hasNext()) {
                EntryInfo info = (EntryInfo)iterator.next();
                Entry entry = info.getEntry();
                String entryName = info.getPath();
                DirectoryNode parent = info.getParent();
                boolean needsBinaryMatch = false;
                for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                    match.matchFileEntry(entryName);
                    if (!match.needsBinaryMatch(entryName)) continue;
                    needsBinaryMatch = true;
                }
                if (!needsBinaryMatch || !(entry instanceof DocumentNode)) continue;
                DocumentInputStream docIn = null;
                ByteReader byteReader = null;
                try {
                    docIn = parent.createDocumentInputStream(entry.getName());
                    byteReader = this.newByteReader(docIn);
                    for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                        match.matchBinaryContent(entryName, byteReader);
                    }
                }
                finally {
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    if (docIn == null) continue;
                    docIn.close();
                }
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private static class EntryInfo {
        private final DirectoryNode parent;
        private final String path;
        private final Entry entry;

        public EntryInfo(DirectoryNode parent, String path, Entry entry) {
            this.parent = parent;
            this.path = path;
            this.entry = entry;
        }

        public DirectoryNode getParent() {
            return this.parent;
        }

        public String getPath() {
            return this.path;
        }

        public Entry getEntry() {
            return this.entry;
        }
    }

    private static class OLE2Walker
    implements Iterator<EntryInfo> {
        private final List<PathIterator> entries = new ArrayList<PathIterator>();
        private final boolean processSubFolders;
        private EntryInfo nextEntry;

        public OLE2Walker(DirectoryNode rootEntry, boolean processSubFolders) {
            this.entries.add(new PathIterator(rootEntry, "", rootEntry.getEntries()));
            this.processSubFolders = processSubFolders;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry == null) {
                while (!this.entries.isEmpty()) {
                    int posToProcess = this.entries.size() - 1;
                    PathIterator currentEntries = this.entries.get(posToProcess);
                    if (currentEntries.getIterator().hasNext()) {
                        Entry entry = currentEntries.getIterator().next();
                        String entryName = entry.getName().trim();
                        String entryPath = currentEntries.getPath() + entryName;
                        if (this.processSubFolders && entry.isDirectoryEntry()) {
                            this.entries.add(new PathIterator((DirectoryNode)entry, entryPath + '/', ((DirectoryEntry)entry).getEntries()));
                        }
                        this.nextEntry = new EntryInfo(currentEntries.getParent(), entryPath, entry);
                        return true;
                    }
                    this.entries.remove(posToProcess);
                }
            }
            return this.nextEntry != null;
        }

        @Override
        public EntryInfo next() {
            if (this.hasNext()) {
                EntryInfo toReturn = this.nextEntry;
                this.nextEntry = null;
                return toReturn;
            }
            throw new NoSuchElementException("No more OLE2 entries");
        }

        private static class PathIterator {
            private final DirectoryNode parent;
            private final String path;
            private final Iterator<Entry> iterator;

            PathIterator(DirectoryNode parent, String path, Iterator<Entry> iterator) {
                this.parent = parent;
                this.path = path;
                this.iterator = iterator;
            }

            public DirectoryNode getParent() {
                return this.parent;
            }

            public String getPath() {
                return this.path;
            }

            public Iterator<Entry> getIterator() {
                return this.iterator;
            }
        }
    }
}

