/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container.httpservice;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import uk.gov.nationalarchives.droid.container.httpservice.DateParseException;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySettings;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureServiceException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureUpdateService;

public class ContainerSignatureHttpService
implements SignatureUpdateService {
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String FILENAME_PATTERN = "container-signature-%s.xml";
    private static final String ERROR_MESSAGE_PATTERN = "The web server could not serve the signature file from the address\n[%s]\nThe server gave the response [%s]";
    private static final String COULD_NOT_FIND_SERVER = "Could not contact the signature web server at\n%s";
    private static final String FILE_NOT_FOUND_404 = "The signature file was not found on the signature webserver at\n[%s]";
    private String endpointUrl;
    private CloseableHttpClient client = HttpClientBuilder.create().build();

    public ContainerSignatureHttpService() {
    }

    public ContainerSignatureHttpService(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    @Override
    public SignatureFileInfo getLatestVersion(int currentVersion) throws SignatureServiceException {
        HttpGet get = new HttpGet(this.endpointUrl);
        try {
            Date versionDate = ContainerSignatureHttpService.getDateFromVersion(currentVersion);
            String dateString = DateUtils.formatDate(versionDate);
            get.addHeader("If-Modified-Since", dateString);
            CloseableHttpResponse response = this.client.execute(get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new SignatureServiceException(String.format(FILE_NOT_FOUND_404, this.endpointUrl));
            }
            if (statusCode != 200 && statusCode != 304) {
                throw new SignatureServiceException(String.format(ERROR_MESSAGE_PATTERN, this.endpointUrl, statusCode));
            }
            int version2 = ContainerSignatureHttpService.getVersion(response);
            SignatureFileInfo signatureFileInfo = new SignatureFileInfo(version2, false, SignatureType.CONTAINER);
            return signatureFileInfo;
        }
        catch (UnknownHostException e) {
            throw new SignatureServiceException(String.format(COULD_NOT_FIND_SERVER, this.endpointUrl));
        }
        catch (IOException | ParseException | DateParseException e) {
            throw new SignatureServiceException(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    private static int getVersion(HttpResponse httpResponse) throws DateParseException {
        int version2 = 0;
        Header header = httpResponse.getFirstHeader(LAST_MODIFIED_HEADER);
        if (header != null) {
            String lastModified = header.getValue();
            Date lastModifiedDate = DateUtils.parseDate(lastModified);
            if (lastModifiedDate == null) {
                throw new DateParseException(lastModified);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
            version2 = Integer.parseInt(sdf.format(lastModifiedDate));
        }
        return version2;
    }

    private static Date getDateFromVersion(int versionNumber) throws ParseException {
        String versionString = Integer.toString(versionNumber);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        return sdf.parse(versionString);
    }

    @Override
    public SignatureFileInfo importSignatureFile(Path targetDir) throws SignatureServiceException {
        HttpGet get = new HttpGet(this.endpointUrl);
        try {
            CloseableHttpResponse response = this.client.execute(get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new SignatureServiceException(String.format(FILE_NOT_FOUND_404, this.endpointUrl));
            }
            if (statusCode != 200 && statusCode != 304) {
                throw new SignatureServiceException(String.format(ERROR_MESSAGE_PATTERN, this.endpointUrl, statusCode));
            }
            int version2 = ContainerSignatureHttpService.getVersion(response);
            SignatureFileInfo signatureFileInfo = new SignatureFileInfo(version2, false, SignatureType.CONTAINER);
            String fileName = String.format(FILENAME_PATTERN, version2);
            Path targetFile = targetDir.resolve(fileName);
            Files.copy(response.getEntity().getContent(), targetFile, new CopyOption[0]);
            signatureFileInfo.setFile(targetFile);
            SignatureFileInfo signatureFileInfo2 = signatureFileInfo;
            return signatureFileInfo2;
        }
        catch (UnknownHostException e) {
            throw new SignatureServiceException(String.format(COULD_NOT_FIND_SERVER, this.endpointUrl));
        }
        catch (IOException | DateParseException e) {
            throw new SignatureServiceException(e);
        }
        finally {
            get.releaseConnection();
        }
    }

    void setEndpointUrl(String url) {
        this.endpointUrl = url;
    }

    @Override
    public void configurationChanged(ConfigurationEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(DroidGlobalProperty.CONTAINER_UPDATE_URL.getName())) {
            this.setEndpointUrl((String)evt.getPropertyValue());
        }
    }

    @Override
    public void onProxyChange(ProxySettings proxySettings) {
        if (proxySettings.isEnabled()) {
            DefaultProxyRoutePlanner proxyRoutePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort()));
            this.client = HttpClients.custom().setRoutePlanner(proxyRoutePlanner).build();
        } else {
            this.client = HttpClientBuilder.create().build();
        }
    }

    @Override
    public void init(DroidGlobalConfig config) {
        this.setEndpointUrl(config.getProperties().getString(DroidGlobalProperty.CONTAINER_UPDATE_URL.getName()));
    }
}

