/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import uk.gov.nationalarchives.droid.container.ContainerFile;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.SignatureParseException;

public class ContainerSignatureSaxParser {
    private JAXBContext context = JAXBContext.newInstance(ContainerSignatureDefinitions.class);

    public ContainerSignatureDefinitions parse(InputStream in) throws SignatureParseException {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            ContainerSignatureDefinitions definitions = (ContainerSignatureDefinitions)unmarshaller.unmarshal(in);
            this.compileAllBinarySignatures(definitions);
            return definitions;
        }
        catch (JAXBException e) {
            throw new SignatureParseException(e.getMessage(), e);
        }
    }

    private void compileAllBinarySignatures(ContainerSignatureDefinitions definitions) {
        for (ContainerSignature signature : definitions.getContainerSignatures()) {
            for (ContainerFile file : signature.getFiles().values()) {
                file.getCompiledBinarySignatures();
            }
        }
    }
}

