/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class ContainerFileIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private long size;
    private Path tempDir;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WindowReader reader;

    public ContainerFileIdentificationRequest(Path tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public final void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000);
        this.size = this.reader.length();
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    @Override
    public final byte getByte(long position) throws IOException {
        int result = this.reader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public final String getExtension() {
        return null;
    }

    @Override
    public final String getFileName() {
        return null;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.reader);
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return null;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return null;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }
}

