/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.container.ContainerIdentifierInit;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureFileReader;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.container.FileFormatMapping;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFormatResolver;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifierFactory;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ErrorCode;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;

public abstract class AbstractContainerIdentifier
implements ContainerIdentifier {
    private static final String ERROR_READING_SIGNATURE_FILE = "Error reading signature file";
    private ContainerSignatureFileReader signatureReader;
    private ContainerIdentifierFactory containerIdentifierFactory;
    private String containerType;
    private ArchiveFormatResolver containerFormatResolver;
    private DroidCore droidCore;
    private ContainerIdentifierInit init = new ContainerIdentifierInit();
    private Map<Integer, List<FileFormatMapping>> formats = new HashMap<Integer, List<FileFormatMapping>>();
    private long maxBytesToScan = -1L;
    private IdentifierEngine identifierEngine;

    @Override
    public final IdentificationResultCollection submit(IdentificationRequest request) throws IOException {
        ContainerSignatureMatchCollection matches = new ContainerSignatureMatchCollection(this.getContainerSignatures(), this.init.getUniqueFileEntries(), this.maxBytesToScan);
        this.process(request, matches);
        IdentificationResultCollection results = new IdentificationResultCollection(request);
        List<ContainerSignatureMatch> matchList = matches.getContainerSignatureMatches();
        int numMatches = matchList.size();
        for (int i = 0; i < numMatches; ++i) {
            ContainerSignatureMatch match = matchList.get(i);
            if (!match.isMatch()) continue;
            List<FileFormatMapping> mappings = this.formats.get(match.getSignature().getId());
            for (FileFormatMapping mapping : mappings) {
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setMethod(IdentificationMethod.CONTAINER);
                result.setRequestMetaData(request.getRequestMetaData());
                result.setPuid(mapping.getPuid());
                result.setName(match.getSignature().getDescription());
                results.addResult(result);
            }
        }
        return results;
    }

    protected abstract void process(IdentificationRequest var1, ContainerSignatureMatchCollection var2) throws IOException;

    public IdentifierEngine getIdentifierEngine() {
        return this.identifierEngine;
    }

    public void setIdentifierEngine(IdentifierEngine identifierEngine) {
        this.identifierEngine = identifierEngine;
    }

    public void addContainerSignature(ContainerSignature containerSignature) {
        this.init.addContainerSignature(containerSignature);
    }

    public void setFormats(Map<Integer, List<FileFormatMapping>> formats) {
        this.formats = formats;
    }

    public List<ContainerSignature> getContainerSignatures() {
        return this.init.getContainerSignatures();
    }

    protected Map<Integer, List<FileFormatMapping>> getFormats() {
        return this.formats;
    }

    public void init() throws SignatureFileException {
        try {
            ContainerSignatureDefinitions defs = this.signatureReader.getDefinitions();
            this.init = new ContainerIdentifierInit();
            this.init.init(defs, this.containerType, this.formats, this.droidCore);
            for (TriggerPuid triggerPuid : defs.getTiggerPuids()) {
                if (!triggerPuid.getContainerType().equals(this.containerType)) continue;
                this.containerIdentifierFactory.addContainerIdentifier(this.containerType, this);
                String puid = triggerPuid.getPuid();
                this.containerFormatResolver.registerPuid(puid, this.containerType);
            }
        }
        catch (SignatureParseException e) {
            throw new SignatureFileException(ERROR_READING_SIGNATURE_FILE, e, ErrorCode.INVALID_SIGNATURE_FILE);
        }
    }

    public void setSignatureReader(ContainerSignatureFileReader signatureReader) {
        this.signatureReader = signatureReader;
    }

    public void setContainerIdentifierFactory(ContainerIdentifierFactory containerIdentifierFactory) {
        this.containerIdentifierFactory = containerIdentifierFactory;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public void setContainerFormatResolver(ArchiveFormatResolver containerFormatResolver) {
        this.containerFormatResolver = containerFormatResolver;
    }

    public void setDroidCore(DroidCore droidCore) {
        this.droidCore = droidCore;
    }

    @Override
    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }
}

