/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jwat.arc.ArcConstants;
import org.jwat.arc.ArcDateParser;
import org.jwat.arc.ArcFieldParsers;
import org.jwat.arc.ArcHeader;
import org.jwat.arc.ArcRecordBase;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;

public abstract class ArcWriter
implements Closeable {
    protected static final int S_INIT = 0;
    protected static final int S_HEADER_WRITTEN = 1;
    protected static final int S_PAYLOAD_WRITTEN = 2;
    protected static final int S_RECORD_CLOSED = 3;
    protected ArcFieldParsers fieldParsers;
    protected byte[] stream_copy_buffer;
    protected boolean bExceptionOnContentLengthMismatch;
    public final Diagnostics<Diagnosis> diagnostics = new Diagnostics();
    protected int state = 0;
    protected OutputStream out;
    protected ArcHeader header;
    protected Long headerContentLength;
    protected long payloadWrittenTotal;

    protected void init() {
        this.fieldParsers = new ArcFieldParsers();
        this.stream_copy_buffer = new byte[8192];
        this.bExceptionOnContentLengthMismatch = true;
    }

    public abstract boolean isCompressed();

    public boolean exceptionOnContentLengthMismatch() {
        return this.bExceptionOnContentLengthMismatch;
    }

    public void setExceptionOnContentLengthMismatch(boolean enabled) {
        this.bExceptionOnContentLengthMismatch = enabled;
    }

    @Override
    public abstract void close() throws IOException;

    public abstract void closeRecord() throws IOException;

    protected void closeRecord_impl() throws IOException {
        Diagnosis diagnosis = null;
        this.out.write(ArcConstants.endMark);
        this.out.flush();
        if (this.headerContentLength == null) {
            diagnosis = new Diagnosis(DiagnosisType.ERROR_EXPECTED, "'Archive-length' header", "Mandatory!");
        } else if (this.headerContentLength != this.payloadWrittenTotal) {
            diagnosis = new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Archive-length' header", Long.toString(this.payloadWrittenTotal), this.headerContentLength.toString());
        }
        if (diagnosis != null) {
            if (this.header != null) {
                this.header.diagnostics.addError(diagnosis);
            } else {
                this.diagnostics.addError(diagnosis);
            }
            if (this.bExceptionOnContentLengthMismatch) {
                throw new IllegalStateException("Payload size does not match content-length!");
            }
        }
        this.header = null;
        this.headerContentLength = null;
    }

    public void writeRawHeader(byte[] header_bytes, Long contentLength) throws IOException {
        if (header_bytes == null) {
            throw new IllegalArgumentException("The 'header_bytes' parameter is null!");
        }
        if (contentLength != null && contentLength < 0L) {
            throw new IllegalArgumentException("The 'contentLength' parameter is negative!");
        }
        if (this.state == 1) {
            throw new IllegalStateException("Headers written back to back!");
        }
        if (this.state == 2) {
            this.closeRecord_impl();
        }
        this.out.write(header_bytes);
        this.state = 1;
        this.header = null;
        this.headerContentLength = contentLength;
        this.payloadWrittenTotal = 0L;
    }

    public abstract byte[] writeHeader(ArcRecordBase var1) throws IOException;

    protected byte[] writeHeader_impl(ArcRecordBase record) throws IOException {
        this.header = record.header;
        this.headerContentLength = this.header.archiveLength;
        if (this.headerContentLength == null && this.header.archiveLengthStr != null) {
            this.headerContentLength = this.fieldParsers.parseLong(this.header.archiveLengthStr, "Archive-length", false);
            if (this.headerContentLength != null && this.headerContentLength < 0L) {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Archive-length' value", this.header.archiveLengthStr, "A non negative number"));
            }
        }
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        String urlStr = this.header.urlUri != null ? this.header.urlUri.toString() : (this.header.urlStr != null && this.header.urlStr.length() > 0 ? this.header.urlStr : "-");
        outBuf.write(urlStr.getBytes());
        String ipAddressStr = this.header.inetAddress != null ? this.header.inetAddress.getHostAddress() : (this.header.ipAddressStr != null && this.header.ipAddressStr.length() > 0 ? this.header.ipAddressStr : "-");
        outBuf.write(" ".getBytes());
        outBuf.write(ipAddressStr.getBytes());
        String archiveDateStr = this.header.archiveDate != null ? ArcDateParser.getDateFormat().format(this.header.archiveDate) : (this.header.archiveDateStr != null && this.header.archiveDateStr.length() > 0 ? this.header.archiveDateStr : "-");
        outBuf.write(" ".getBytes());
        outBuf.write(archiveDateStr.getBytes());
        String contentTypeStr = this.header.contentType != null ? this.header.contentType.toStringShort() : (this.header.contentTypeStr != null && this.header.contentTypeStr.length() > 0 ? this.header.contentTypeStr : "-");
        outBuf.write(" ".getBytes());
        outBuf.write(contentTypeStr.getBytes());
        if (this.header.recordFieldVersion == 2) {
            String resultCodeStr = this.header.resultCode != null ? this.header.resultCode.toString() : (this.header.resultCodeStr != null && this.header.resultCodeStr.length() > 0 ? this.header.resultCodeStr : "-");
            outBuf.write(" ".getBytes());
            outBuf.write(resultCodeStr.getBytes());
            String checksumStr = this.header.checksumStr != null && this.header.checksumStr.length() > 0 ? this.header.checksumStr : "-";
            outBuf.write(" ".getBytes());
            outBuf.write(checksumStr.getBytes());
            String locationStr = this.header.locationStr != null && this.header.locationStr.length() > 0 ? this.header.locationStr : "-";
            outBuf.write(" ".getBytes());
            outBuf.write(locationStr.getBytes());
            String offsetStr = this.header.offset != null ? this.header.offset.toString() : (this.header.offsetStr != null && this.header.offsetStr.length() > 0 ? this.header.offsetStr : "-");
            outBuf.write(" ".getBytes());
            outBuf.write(offsetStr.getBytes());
            String filenameStr = this.header.filenameStr != null && this.header.filenameStr.length() > 0 ? this.header.filenameStr : "-";
            outBuf.write(" ".getBytes());
            outBuf.write(filenameStr.getBytes());
        }
        String archiveLengthStr = this.header.archiveLength != null ? this.header.archiveLength.toString() : (this.header.archiveLengthStr != null && this.header.archiveLengthStr.length() > 0 ? this.header.archiveLengthStr : "-");
        outBuf.write(" ".getBytes());
        outBuf.write(archiveLengthStr.getBytes());
        outBuf.write("\n".getBytes());
        byte[] headerBytes = outBuf.toByteArray();
        this.out.write(headerBytes);
        this.state = 1;
        this.payloadWrittenTotal = 0L;
        return headerBytes;
    }

    public long streamPayload(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The 'in' parameter is null!");
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Write a header before writing payload!");
        }
        long written = 0L;
        int read = 0;
        while (read != -1) {
            this.out.write(this.stream_copy_buffer, 0, read);
            written += (long)read;
            read = in.read(this.stream_copy_buffer);
        }
        this.state = 2;
        this.payloadWrittenTotal += written;
        return written;
    }

    public long writePayload(byte[] b) throws IOException {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Write a header before writing payload!");
        }
        this.out.write(b);
        this.state = 2;
        this.payloadWrittenTotal += (long)b.length;
        return b.length;
    }

    public long writePayload(byte[] b, int offset, int len) throws IOException {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Write a header before writing payload!");
        }
        this.out.write(b, offset, len);
        this.state = 2;
        this.payloadWrittenTotal += (long)len;
        return len;
    }
}

