/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jwat.arc.ArcConstants;
import org.jwat.arc.ArcFieldParsers;
import org.jwat.arc.ArcVersion;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.MaxLengthRecordingInputStream;
import org.jwat.common.PayloadWithHeaderAbstract;

public class ArcVersionHeader
extends PayloadWithHeaderAbstract {
    public static final int PUSHBACK_BUFFER_SIZE = 32;
    protected ArcFieldParsers fieldParsers;
    public boolean bValidVersionFormat;
    public String versionStr;
    protected boolean isVersionValid;
    public boolean isValidBlockdDesc;
    public int blockDescVersion;
    public String blockDesc;
    public String versionNumberStr;
    public Integer versionNumber;
    public String reservedStr;
    public Integer reserved;
    public String originCode;
    public ArcVersion version;

    public static ArcVersionHeader create(ArcVersion version2, String originCode) {
        if (version2 == null) {
            throw new IllegalArgumentException("'version' argument is null!");
        }
        if (originCode == null || originCode.length() == 0) {
            throw new IllegalArgumentException("'originCode' argument is null or empty!");
        }
        ArcVersionHeader versionHeader = new ArcVersionHeader();
        versionHeader.versionNumber = version2.major;
        versionHeader.reserved = version2.minor;
        versionHeader.originCode = originCode;
        switch (version2) {
            case VERSION_1: 
            case VERSION_1_1: {
                versionHeader.blockDescVersion = 1;
                versionHeader.blockDesc = ArcConstants.VERSION_1_BLOCK_DEF;
                break;
            }
            case VERSION_2: {
                versionHeader.blockDescVersion = 2;
                versionHeader.blockDesc = ArcConstants.VERSION_2_BLOCK_DEF;
            }
        }
        versionHeader.bValidVersionFormat = true;
        versionHeader.isVersionValid = true;
        versionHeader.isValidBlockdDesc = true;
        return versionHeader;
    }

    public void rebuild() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.versionNumber));
        sb.append(" ");
        sb.append(Integer.toString(this.reserved));
        sb.append(" ");
        sb.append(this.originCode);
        sb.append("\n");
        sb.append(this.blockDesc);
        sb.append("\n");
        this.header = sb.toString().getBytes("ISO8859-1");
    }

    public static ArcVersionHeader processPayload(ByteCountingPushBackInputStream pbin, long length, String digestAlgorithm, ArcFieldParsers fieldParsers, Diagnostics<Diagnosis> diagnostics) throws IOException {
        if (pbin == null) {
            throw new IllegalArgumentException("The inputstream 'pbin' is null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("The 'length' is less than zero: " + length);
        }
        if (fieldParsers == null) {
            throw new IllegalArgumentException("'fieldParsers' is null");
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException("'diagnostics' is null");
        }
        ArcVersionHeader avh = new ArcVersionHeader();
        avh.in_pb = pbin;
        avh.totalLength = length;
        avh.digestAlgorithm = digestAlgorithm;
        avh.fieldParsers = fieldParsers;
        avh.diagnostics = diagnostics;
        avh.initProcess();
        return avh;
    }

    @Override
    protected boolean readHeader(MaxLengthRecordingInputStream in, long payloadLength) throws IOException {
        boolean bIsValidVersionBlock;
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(in, 32);
        String versionLine = pbin.readLine();
        String blockDescLine = pbin.readLine();
        if (versionLine != null && versionLine.length() > 0) {
            String[] versionArr = versionLine.split(" ", -1);
            if (versionArr.length != ArcConstants.VERSION_DESC_FIELDS.length) {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID, "ARC version block", "Invalid version description"));
            }
            switch (versionArr.length) {
                default: {
                    this.originCode = versionArr[2];
                    this.originCode = this.fieldParsers.parseString(this.originCode, "Origin-code", false);
                }
                case 2: {
                    this.reservedStr = versionArr[1];
                    this.reserved = this.fieldParsers.parseInteger(this.reservedStr, "Reserved", false);
                }
                case 1: {
                    this.versionNumberStr = versionArr[0];
                    this.versionNumber = this.fieldParsers.parseInteger(this.versionNumberStr, "Version-number", false);
                }
                case 0: 
            }
            this.version = null;
            if (this.versionNumber != null && this.reserved != null) {
                this.bValidVersionFormat = true;
                this.versionStr = Integer.toString(this.versionNumber) + "." + Integer.toString(this.reserved);
                this.version = ArcVersion.fromValues(this.versionNumber, this.reserved);
            }
            boolean bl = this.isVersionValid = this.version != null;
            if (!this.isVersionValid) {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID, "ARC version block", "Invalid version: [version number: " + this.versionNumber + ", reserved: " + this.reserved + ']'));
            }
        } else {
            this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "ARC version block", "Version line empty"));
        }
        if (blockDescLine != null && blockDescLine.length() > 0) {
            if (ArcConstants.VERSION_1_BLOCK_DEF.equals(blockDescLine)) {
                this.isValidBlockdDesc = true;
                this.blockDescVersion = 1;
            } else if (ArcConstants.VERSION_2_BLOCK_DEF.equals(blockDescLine)) {
                this.isValidBlockdDesc = true;
                this.blockDescVersion = 2;
            } else {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID, "ARC version block", "Unsupported version block definition"));
            }
        } else {
            this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "ARC version block", "Block definition empty"));
        }
        boolean bl = bIsValidVersionBlock = this.version != null && this.blockDescVersion > 0;
        if (bIsValidVersionBlock) {
            switch (this.blockDescVersion) {
                case 1: {
                    if (this.version == ArcVersion.VERSION_1 || this.version == ArcVersion.VERSION_1_1) break;
                    bIsValidVersionBlock = false;
                    break;
                }
                case 2: {
                    if (this.version == ArcVersion.VERSION_2) break;
                    bIsValidVersionBlock = false;
                }
            }
            if (!bIsValidVersionBlock) {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID, "ARC version block", "Version number does not match the block definition"));
            }
        }
        return bIsValidVersionBlock;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("\nArcVersionHeader : [\n");
        builder.append("isValid:");
        builder.append(this.isValid());
        builder.append(',');
        builder.append("versionNumber:");
        if (this.versionNumber != null) {
            builder.append(this.versionNumber);
        }
        builder.append(',');
        builder.append("reserved:");
        if (this.reserved != null) {
            builder.append(this.reserved);
        }
        builder.append(',');
        builder.append("originCode:");
        if (this.originCode != null) {
            builder.append(this.originCode);
        }
        builder.append(',');
        builder.append("blockDescVersion:");
        builder.append(this.blockDescVersion);
        builder.append("]\n");
        return builder.toString();
    }
}

