/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Date;
import org.jwat.arc.ArcHeader;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcRecord;
import org.jwat.arc.ArcVersion;
import org.jwat.arc.ArcVersionBlock;
import org.jwat.arc.ArcVersionHeader;
import org.jwat.common.Base16;
import org.jwat.common.Base32;
import org.jwat.common.Base64;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.ContentType;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.Digest;
import org.jwat.common.HttpHeader;
import org.jwat.common.NewlineParser;
import org.jwat.common.Payload;
import org.jwat.common.PayloadOnClosedHandler;
import org.jwat.common.PayloadWithHeaderAbstract;
import org.jwat.common.Uri;

public abstract class ArcRecordBase
implements PayloadOnClosedHandler,
Closeable {
    public static final int RT_VERSION_BLOCK = 1;
    public static final int RT_ARC_RECORD = 2;
    public static final int TOSTRING_BUFFER_SIZE = 256;
    protected boolean bIsCompliant;
    protected ArcReader reader;
    protected ByteCountingPushBackInputStream in;
    protected ArcVersion version;
    protected long startOffset = -1L;
    protected long consumed;
    public Diagnostics<Diagnosis> diagnostics;
    public NewlineParser nlp = new NewlineParser();
    public int recordType;
    public int trailingNewLines;
    public ArcHeader header;
    public ArcVersionHeader versionHeader;
    protected boolean bPayloadClosed;
    protected boolean bClosed;
    protected Payload payload;
    protected boolean bHasPseudoEmptyPayload;
    protected HttpHeader httpHeader;
    public Digest computedBlockDigest;
    public Digest computedPayloadDigest;
    public byte[] excessiveMetadata;

    public static ArcRecordBase parseRecord(ByteCountingPushBackInputStream in, ArcReader reader) throws IOException {
        ArcRecordBase record = null;
        long startOffset = in.getConsumed();
        Diagnostics<Diagnosis> diagnostics = new Diagnostics<Diagnosis>();
        ArcHeader header = ArcHeader.initHeader(reader, startOffset, diagnostics);
        reader.fieldParsers.diagnostics = diagnostics;
        if (header.parseHeader(in)) {
            if (reader.arpCallback != null) {
                reader.arpCallback.arcParsedRecordHeader(reader, startOffset, header);
            }
            if (header.urlScheme != null && header.urlScheme.startsWith("filedesc") && (record = ArcVersionBlock.parseVersionBlock(reader, diagnostics, header, reader.fieldParsers, in)) != null) {
                reader.versionHeader = record.versionHeader;
            }
            if (record == null && (record = ArcRecord.parseArcRecord(reader, diagnostics, header, in)) != null && reader.versionHeader != null) {
                record.version = reader.versionHeader.version;
            }
        }
        if (record != null) {
            ++reader.records;
            record.startOffset = startOffset;
            if (header.offset != null && header.startOffset > 0L && header.offset != header.startOffset) {
                diagnostics.addError(new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Offset' value", header.offset.toString(), Long.toString(header.startOffset)));
            }
            if (reader.records == 1) {
                if (record.recordType == 2) {
                    diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", "Expected a version block as the first record."));
                }
            } else if (record.recordType == 1) {
                diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", "Expected an ARC record not version block."));
            }
            if (reader.versionHeader != null && reader.versionHeader.blockDescVersion > 0 && record.header.recordFieldVersion != reader.versionHeader.blockDescVersion) {
                diagnostics.addError(new Diagnosis(DiagnosisType.INVALID_EXPECTED, "ARC record does not match the version block definition", Integer.toString(record.header.recordFieldVersion), Integer.toString(reader.versionHeader.blockDescVersion)));
            }
            record.bIsCompliant = !diagnostics.hasErrors() && !diagnostics.hasWarnings();
            reader.bIsCompliant &= record.bIsCompliant;
        } else {
            long excess = in.getConsumed() - startOffset;
            reader.consumed += excess;
            reader.diagnostics.addAll(diagnostics);
            if (diagnostics.hasErrors() || diagnostics.hasWarnings()) {
                reader.errors += diagnostics.getErrors().size();
                reader.warnings += diagnostics.getWarnings().size();
                reader.bIsCompliant = false;
            }
            if (reader.records == 0) {
                reader.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", "One or more records"));
                ++reader.errors;
                reader.bIsCompliant = false;
            }
            if (excess != 0L) {
                reader.diagnostics.addError(new Diagnosis(DiagnosisType.UNDESIRED_DATA, "Trailing data", "Garbage data found at offset=" + startOffset + " - length=" + excess));
            }
        }
        return record;
    }

    @Override
    public void payloadClosed() throws IOException {
        if (!this.bPayloadClosed) {
            if (this.payload != null) {
                PayloadWithHeaderAbstract payloadHeaderWrapped;
                byte[] digest;
                if (this.payload.getUnavailable() > 0L) {
                    this.addErrorDiagnosis(DiagnosisType.INVALID_DATA, "Payload length mismatch", "Payload truncated");
                }
                if ((digest = this.payload.getDigest()) != null) {
                    this.computedBlockDigest = new Digest();
                    this.computedBlockDigest.digestBytes = digest;
                    this.computedBlockDigest.algorithm = this.reader.blockDigestAlgorithm;
                    if (this.reader.blockDigestEncoding != null) {
                        if ("base32".equals(this.reader.blockDigestEncoding)) {
                            this.computedBlockDigest.encoding = "base32";
                            this.computedBlockDigest.digestString = Base32.encodeArray(this.computedBlockDigest.digestBytes);
                        } else if ("base64".equals(this.reader.blockDigestEncoding)) {
                            this.computedBlockDigest.encoding = "base64";
                            this.computedBlockDigest.digestString = Base64.encodeArray(this.computedBlockDigest.digestBytes);
                        } else if ("base16".equals(this.reader.blockDigestEncoding)) {
                            this.computedBlockDigest.encoding = "base16";
                            this.computedBlockDigest.digestString = Base16.encodeArray(this.computedBlockDigest.digestBytes);
                        } else {
                            this.addErrorDiagnosis(DiagnosisType.INVALID_DATA, "Block digest encoding scheme", this.reader.blockDigestEncoding);
                        }
                    }
                }
                if ((payloadHeaderWrapped = this.payload.getPayloadHeaderWrapped()) != null && payloadHeaderWrapped.isValid() && (digest = payloadHeaderWrapped.getDigest()) != null) {
                    this.computedPayloadDigest = new Digest();
                    this.computedPayloadDigest.digestBytes = digest;
                    this.computedPayloadDigest.algorithm = this.reader.payloadDigestAlgorithm;
                    if (this.reader.payloadDigestEncoding != null) {
                        if ("base32".equals(this.reader.payloadDigestEncoding)) {
                            this.computedPayloadDigest.encoding = "base32";
                            this.computedPayloadDigest.digestString = Base32.encodeArray(this.computedPayloadDigest.digestBytes);
                        } else if ("base64".equals(this.reader.payloadDigestEncoding)) {
                            this.computedPayloadDigest.encoding = "base64";
                            this.computedPayloadDigest.digestString = Base64.encodeArray(this.computedPayloadDigest.digestBytes);
                        } else if ("base16".equals(this.reader.payloadDigestEncoding)) {
                            this.computedPayloadDigest.encoding = "base16";
                            this.computedPayloadDigest.digestString = Base16.encodeArray(this.computedPayloadDigest.digestBytes);
                        } else {
                            this.addErrorDiagnosis(DiagnosisType.INVALID_DATA, "Payload digest encoding scheme", this.reader.payloadDigestEncoding);
                        }
                    }
                }
            }
            this.trailingNewLines = this.nlp.parseLFs(this.in, this.diagnostics);
            if (this.reader.bStrict && this.trailingNewLines != 1) {
                this.addErrorDiagnosis(DiagnosisType.INVALID_EXPECTED, "Trailing newlines", Integer.toString(this.trailingNewLines), Integer.toString(1));
            }
            if (this.diagnostics.hasErrors() || this.diagnostics.hasWarnings()) {
                this.bIsCompliant = false;
                this.reader.errors += this.diagnostics.getErrors().size();
                this.reader.warnings += this.diagnostics.getWarnings().size();
            } else {
                this.bIsCompliant = true;
            }
            this.reader.bIsCompliant &= this.bIsCompliant;
            this.consumed = this.in.getConsumed() - this.startOffset;
            this.bPayloadClosed = true;
            this.reader.recordClosed();
        }
    }

    public boolean isClosed() {
        return this.bClosed;
    }

    @Override
    public void close() throws IOException {
        if (!this.bClosed) {
            if (this.payload != null) {
                this.payload.close();
            }
            this.payloadClosed();
            this.reader = null;
            this.in = null;
            this.bClosed = true;
        }
    }

    public boolean isCompliant() {
        return this.bIsCompliant;
    }

    public long getStartOffset() {
        return this.header.startOffset;
    }

    public long getConsumed() {
        return this.consumed;
    }

    protected abstract void processPayload(ByteCountingPushBackInputStream var1, ArcReader var2) throws IOException;

    public boolean hasPayload() {
        return this.payload != null;
    }

    public boolean hasPseudoEmptyPayload() {
        return this.bHasPseudoEmptyPayload;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public InputStream getPayloadContent() {
        return this.payload != null ? this.payload.getInputStream() : null;
    }

    public HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    public boolean isValidStreamOfCRLF(InputStream in) throws IOException {
        int b;
        if (in == null) {
            throw new IllegalArgumentException("'in' is null!");
        }
        boolean isValid = true;
        while ((b = in.read()) != -1) {
            if (b == 10 || b == 13) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    protected void addErrorDiagnosis(DiagnosisType type, String entity, String ... information) {
        this.diagnostics.addError(new Diagnosis(type, entity, information));
    }

    public ArcVersion getVersion() {
        return this.version;
    }

    public String getUrlStr() {
        return this.header.urlStr;
    }

    public Uri getUrl() {
        return this.header.urlUri;
    }

    public String getScheme() {
        return this.header.urlScheme;
    }

    public String getIpAddress() {
        return this.header.ipAddressStr;
    }

    public InetAddress getInetAddress() {
        return this.header.inetAddress;
    }

    public String getArchiveDateStr() {
        return this.header.archiveDateStr;
    }

    public Date getArchiveDate() {
        return this.header.archiveDate;
    }

    public String getContentTypeStr() {
        return this.header.contentTypeStr;
    }

    public ContentType getContentType() {
        return this.header.contentType;
    }

    public String getResultCodeStr() {
        return this.header.resultCodeStr;
    }

    public Integer getResultCode() {
        return this.header.resultCode;
    }

    public String getChecksum() {
        return this.header.checksumStr;
    }

    public String getLocation() {
        return this.header.locationStr;
    }

    public String getOffsetStr() {
        return this.header.offsetStr;
    }

    public Long getOffset() {
        return this.header.offset;
    }

    public String getFileName() {
        return this.header.filenameStr;
    }

    public String getArchiveLengthStr() {
        return this.header.archiveLengthStr;
    }

    public Long getArchiveLength() {
        return this.header.archiveLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        this.header.toStringBuilder(sb);
        return sb.toString();
    }
}

