/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcReaderCompressed;
import org.jwat.arc.ArcReaderUncompressed;
import org.jwat.archive.common.ReaderFactoryAbstract;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Scheme;
import org.jwat.gzip.GzipReader;

public class ArcReaderFactory
extends ReaderFactoryAbstract {
    public static final int PUSHBACK_BUFFER_SIZE = 32;

    protected ArcReaderFactory() {
    }

    public static boolean isArcFile(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte["filedesc:".length()];
        byte[] arcBytes = "filedesc:".getBytes();
        pbin.peek(streamBytes);
        return Arrays.equals(arcBytes, streamBytes);
    }

    public static boolean isArcRecord(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte[32];
        pbin.peek(streamBytes);
        return Scheme.startsWithScheme(streamBytes);
    }

    public static ArcReader getReader(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(in, buffer_size), 32);
        if (GzipReader.isGzipped(pbin)) {
            return new ArcReaderCompressed(new GzipReader(pbin), buffer_size);
        }
        return new ArcReaderUncompressed(pbin);
    }

    public static ArcReader getReader(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(in, 32);
        if (GzipReader.isGzipped(pbin)) {
            return new ArcReaderCompressed(new GzipReader(pbin));
        }
        return new ArcReaderUncompressed(pbin);
    }

    public static ArcReaderUncompressed getReaderUncompressed() {
        return new ArcReaderUncompressed();
    }

    public static ArcReaderUncompressed getReaderUncompressed(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(in, 32);
        return new ArcReaderUncompressed(pbin);
    }

    public static ArcReaderUncompressed getReaderUncompressed(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(in, buffer_size), 32);
        return new ArcReaderUncompressed(pbin);
    }

    public static ArcReaderCompressed getReaderCompressed() {
        return new ArcReaderCompressed();
    }

    public static ArcReaderCompressed getReaderCompressed(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        return new ArcReaderCompressed(new GzipReader(in));
    }

    public static ArcReaderCompressed getReaderCompressed(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        return new ArcReaderCompressed(new GzipReader(new BufferedInputStream(in, buffer_size)));
    }
}

