/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.net.InetAddress;
import java.util.Date;
import org.jwat.arc.ArcDateParser;
import org.jwat.common.ContentType;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.IPAddressParser;
import org.jwat.common.Uri;
import org.jwat.common.UriProfile;

public class ArcFieldParsers {
    public Diagnostics<Diagnosis> diagnostics;

    public void addInvalidExpectedError(String entity, String ... information) {
        this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID_EXPECTED, entity, information));
    }

    public void addRequiredMissingError(String entity) {
        this.diagnostics.addError(new Diagnosis(DiagnosisType.REQUIRED_MISSING, entity, new String[0]));
    }

    public String parseString(String str, String field, boolean nullable) {
        if (!(nullable || str != null && str.trim().length() != 0)) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return str;
    }

    public Integer parseInteger(String intStr, String field, boolean nullable) {
        Integer iVal = null;
        if (intStr != null && intStr.length() > 0) {
            try {
                iVal = Integer.valueOf(intStr);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", intStr, "Numeric format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return iVal;
    }

    public Long parseLong(String longStr, String field, boolean nullable) {
        Long lVal = null;
        if (longStr != null && longStr.length() > 0) {
            try {
                lVal = Long.valueOf(longStr);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", longStr, "Numeric format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return lVal;
    }

    public ContentType parseContentType(String contentTypeStr, String field, boolean nullable) {
        ContentType contentType = null;
        if (contentTypeStr != null && contentTypeStr.length() != 0) {
            contentType = ContentType.parseContentType(contentTypeStr);
            if (contentType == null) {
                this.addInvalidExpectedError("'" + field + "' value", contentTypeStr, "<type>/<sub-type>(; <argument>=<value>)*");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return contentType;
    }

    public InetAddress parseIpAddress(String ipAddress, String field, boolean nullable) {
        InetAddress inetAddr = null;
        if (ipAddress != null && ipAddress.length() > 0) {
            inetAddr = IPAddressParser.getAddress(ipAddress);
            if (inetAddr == null) {
                this.addInvalidExpectedError("'" + field + "' value", ipAddress, "IPv4 or IPv6 format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return inetAddr;
    }

    public Uri parseUri(String uriStr, UriProfile uriProfile, String field, boolean nullable) {
        Uri uri = null;
        if (uriStr != null && uriStr.length() != 0) {
            String scheme;
            try {
                uri = new Uri(uriStr, uriProfile);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", uriStr, e.getMessage());
            }
            if (uri != null && (scheme = uri.getScheme()) == null) {
                uri = null;
                this.addInvalidExpectedError("'" + field + "' value", uriStr, "Absolute URI");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return uri;
    }

    public Date parseDate(String dateStr, String field, boolean nullable) {
        Date date = null;
        if (dateStr != null && dateStr.length() > 0) {
            date = ArcDateParser.getDate(dateStr);
            if (date == null) {
                this.addInvalidExpectedError("'" + field + "' value", dateStr, "yyyyMMddHHmmss");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return date;
    }
}

