/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSInteger
extends XSDecimal {
    private static final String XS_INTEGER = "xs:integer";
    private BigInteger _value;

    public XSInteger() {
        this(BigInteger.valueOf(0L));
    }

    public XSInteger(BigInteger x) {
        super(new BigDecimal(x));
        this._value = x;
    }

    public XSInteger(String x) {
        super(new BigDecimal(x));
        this._value = new BigInteger(x);
    }

    @Override
    public String string_type() {
        return XS_INTEGER;
    }

    @Override
    public String type_name() {
        return "integer";
    }

    @Override
    public String getStringValue() {
        return this._value.toString();
    }

    @Override
    public Number getNativeValue() {
        return this._value;
    }

    @Override
    public boolean zero() {
        return this._value.compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            BigInteger bigInt = this.castInteger(aat);
            return new XSInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.invalidLexicalValue(e);
        }
    }

    private BigInteger castInteger(Item aat) {
        if (aat instanceof XSBoolean) {
            if (aat.getStringValue().equals("true")) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        if (aat instanceof XSDecimal || aat instanceof XSFloat || aat instanceof XSDouble) {
            BigDecimal bigDec = new BigDecimal(aat.getStringValue());
            return bigDec.toBigInteger();
        }
        return new BigInteger(aat.getStringValue());
    }

    private boolean isCastable(Item aat) throws DynamicError {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType) {
            return this.isLexicalValue(aat.getStringValue());
        }
        return aat instanceof XSBoolean || aat instanceof NumericType;
    }

    @Override
    protected boolean isLexicalValue(String value) {
        try {
            new BigInteger(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public BigInteger int_value() {
        return this._value;
    }

    public void set_int(BigInteger x) {
        this._value = x;
        this.set_double(x.intValue());
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSInteger)) {
            DynamicError.throw_type_error();
        }
        XSInteger val = (XSInteger)at;
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value().add(val.int_value())));
    }

    private ResultSequence convertResultSequence(ResultSequence arg) throws DynamicError {
        ResultSequence carg = arg;
        Iterator<Item> it = carg.iterator();
        while (it.hasNext()) {
            AnyType type = (AnyType)it.next();
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.invalidType();
        }
        carg = this.constructor(carg);
        return carg;
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSInteger val = (XSInteger)XSInteger.get_single_type(carg, XSInteger.class);
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value().subtract(val.int_value())));
    }

    @Override
    public ResultSequence times(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSInteger val = (XSInteger)XSInteger.get_single_type(carg, XSInteger.class);
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value().multiply(val.int_value())));
    }

    @Override
    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSInteger val = (XSInteger)XSInteger.get_single_type(carg, XSInteger.class);
        BigInteger result = this.int_value().remainder(val.int_value());
        return ResultSequenceFactory.create_new(new XSInteger(result));
    }

    @Override
    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value().multiply(BigInteger.valueOf(-1L))));
    }

    @Override
    public NumericType abs() {
        return new XSInteger(this.int_value().abs());
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSInteger val = (XSInteger)XSInteger.get_single_type(carg, XSInteger.class);
        int compareResult = this.int_value().compareTo(val.int_value());
        return compareResult > 0;
    }

    @Override
    protected Item convertArg(AnyType arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new(arg);
        rs = this.constructor(rs);
        Item carg = rs.first();
        return carg;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSInteger val = (XSInteger)XSInteger.get_single_type(carg, XSInteger.class);
        int compareResult = this.int_value().compareTo(val.int_value());
        return compareResult < 0;
    }

    @Override
    public ResultSequence div(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = this.getValue().divide(val.getValue(), 18, 6);
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_INTEGER;
    }
}

