/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.lang.UCharacter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.StringCodePointIterator;

public class FnTranslate
extends Function {
    private static Collection<SeqType> _expected_args = null;

    public FnTranslate() {
        super(new QName("translate"), 3);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnTranslate.translate(args);
    }

    public static ResultSequence translate(Collection<ResultSequence> args) throws DynamicError {
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnTranslate.expected_args());
        Iterator<ResultSequence> argi = cargs.iterator();
        ResultSequence arg1 = argi.next();
        ResultSequence arg2 = argi.next();
        ResultSequence arg3 = argi.next();
        if (arg1.empty()) {
            return new XSString("");
        }
        String str = ((XSString)arg1.first()).value();
        String mapstr = ((XSString)arg2.first()).value();
        String transstr = ((XSString)arg3.first()).value();
        Map<Integer, Integer> replacements = FnTranslate.buildReplacementMap(mapstr, transstr);
        StringBuffer sb = new StringBuffer(str.length());
        StringCodePointIterator strIter = new StringCodePointIterator(str);
        int input = strIter.current();
        while (input != -1) {
            Integer inputCodepoint = new Integer(input);
            if (replacements.containsKey(inputCodepoint)) {
                Integer replaceWith = replacements.get(inputCodepoint);
                if (replaceWith != null) {
                    sb.append(UCharacter.toChars(replaceWith));
                }
            } else {
                sb.append(UCharacter.toChars(input));
            }
            input = strIter.next();
        }
        return new XSString(sb.toString());
    }

    private static Map<Integer, Integer> buildReplacementMap(String mapstr, String transstr) {
        HashMap<Integer, Integer> replacements = new HashMap<Integer, Integer>(mapstr.length() * 4);
        StringCodePointIterator mapIter = new StringCodePointIterator(mapstr);
        StringCodePointIterator transIter = new StringCodePointIterator(transstr);
        int mapFrom = mapIter.current();
        int mapTo = transIter.current();
        while (mapFrom != -1) {
            Integer codepointFrom = new Integer(mapFrom);
            if (!replacements.containsKey(codepointFrom)) {
                Integer replacement = mapTo != -1 ? new Integer(mapTo) : null;
                replacements.put(codepointFrom, replacement);
            }
            mapFrom = mapIter.next();
            mapTo = transIter.next();
        }
        return replacements;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

