/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import org.eclipse.wst.xml.xpath2.processor.XPathException;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;

public class DynamicError
extends XPathException {
    private static final long serialVersionUID = -6146830764753685791L;
    private String _code;
    private TypeError _te;

    public DynamicError(String code, String err, Throwable cause) {
        super(err, cause);
        this._code = code;
        this._te = null;
    }

    public DynamicError(TypeError te) {
        super(te.reason(), te);
        this._te = te;
        this._code = te.code();
    }

    public String code() {
        if (this._te != null) {
            return this._te.code();
        }
        return this._code;
    }

    public static DynamicError cant_cast(String err) {
        return DynamicError.cant_cast(err, null);
    }

    public static DynamicError cant_cast(String err, Throwable cause) {
        String error = "Can't cast to required type.";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FORG0001", error, cause);
    }

    public static DynamicError throw_type_error() throws DynamicError {
        throw DynamicError.argument_type_error(null);
    }

    public static DynamicError argument_type_error(Class<?> type) {
        return new DynamicError("FORG0006", type != null ? "Invalid argument type :" + type.getName() : "Invalid argument type", null);
    }

    public static DynamicError invalidType() throws DynamicError {
        throw new DynamicError(TypeError.invalid_type(null));
    }

    public static DynamicError inputToLargeForDecimal() throws DynamicError {
        throw new DynamicError("FOCA0001", "Input value too large for decimal", null);
    }

    public static DynamicError user_error(String ns, String code, String desc) {
        String error = "Error reported by fn:error.";
        if (desc != null) {
            error = desc + " (reported by fn:error)";
        }
        return new DynamicError(code, error, null);
    }

    public static DynamicError user_error(String err) {
        String error = "Error reported by fn:error.";
        if (err != null) {
            error = err + " (reported by fn:error)";
        }
        return new DynamicError("FOER0000", error, null);
    }

    public static DynamicError regex_flags_error(String err) {
        String error = "Invalid regular expression flag parameter.";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FORX0001", error, null);
    }

    public static DynamicError regex_error(String err, Throwable cause) {
        String error = "Invalid regular expression.";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FORX0002", error, cause);
    }

    public static DynamicError regex_match_zero_length(String err) {
        String error = "Invalid regular expression.";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FORX0003", error, null);
    }

    public static DynamicError unsupported_codepoint(String err, Throwable cause) {
        String error = "Unsupported codepoint";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FOCH0001", error, cause);
    }

    public static DynamicError unsupported_collation(String collationName) {
        String error = "Unsupported collation URI. ";
        if (collationName != null) {
            error = error + " " + collationName;
        }
        return new DynamicError("FOCH0002", error, null);
    }

    public static DynamicError unsupported_normalization_form(String err) {
        String error = "Unsupported normalization form: ";
        if (err != null) {
            error = error + " " + err;
        }
        return new DynamicError("FOCH0003", error, null);
    }

    public static DynamicError runtime_error(String msg, Throwable err) {
        String error = "Error at runtime: " + msg + ": " + err.getMessage();
        return new DynamicError("FOER0000", error, err);
    }

    private static DynamicError make_error(String code, String err, String msg, Throwable cause) {
        String error = err;
        if (msg != null) {
            error = error + msg;
        }
        return new DynamicError(code, error, cause);
    }

    public static DynamicError lexical_error(String msg, Throwable cause) {
        return DynamicError.make_error("FOCA0002", "Invalid lexical value.", msg, cause);
    }

    public static DynamicError not_cmp(String msg) {
        return DynamicError.make_error("FOTY0012", "Items not comparable", msg, null);
    }

    public static DynamicError more_one_item(String msg) {
        return DynamicError.make_error("FORG0003", "fn:zero-or-one called with a sequence containing more than one item", msg, null);
    }

    public static DynamicError empty_seq(String msg) {
        return DynamicError.make_error("FORG0004", "fn:one-or-more called with a sequence containing no items", msg, null);
    }

    public static DynamicError not_one(String msg) {
        return DynamicError.make_error("FORG0005", "fn:exactly-one called with a sequence containing zero or more than one item", msg, null);
    }

    public static DynamicError invalidCollectionArgument() {
        return DynamicError.make_error("FODC0004", "Invalid argument to fn:doc", null, null);
    }

    public static DynamicError invalid_doc(String msg) {
        return DynamicError.make_error("FODC0005", "Invalid argument to fn:doc", msg, null);
    }

    public static DynamicError doc_not_found(String msg, Throwable cause) {
        return DynamicError.make_error("FODC0002", "Document argument fn:doc not found", msg, cause);
    }

    public static DynamicError div_zero(String msg) {
        return DynamicError.make_error("FOAR0001", "Division by zero", msg, null);
    }

    public static DynamicError numeric_overflow(String msg) {
        return DynamicError.make_error("FOAR0002", "Numeric overflow/underflow", msg, null);
    }

    public static DynamicError contextUndefined() {
        return DynamicError.make_error("XPDY0002", "Context is undefined.", "", null);
    }

    public static DynamicError invalidForCastConstructor() {
        return DynamicError.make_error("FORG0001", "data type invalid for cast or constructor", null, null);
    }

    public static DynamicError invalidPrefix() {
        return DynamicError.make_error("FONS0004", "No namespace found for prefix.", null, null);
    }

    public static DynamicError noContextDoc() {
        return DynamicError.make_error("FODC0001", "No context document.", null, null);
    }

    public static DynamicError noBaseURI() {
        return DynamicError.make_error("FONS0005", "Base-uri not defined in the static context.", null, null);
    }

    public static DynamicError errorResolvingURI(Throwable cause) {
        return DynamicError.make_error("FORG0002", "Invalid argument to fn:resolve-uri().", null, cause);
    }

    public static DynamicError invalidTimezone() {
        return DynamicError.make_error("FODT0003", "Invalid timezone value.", null, null);
    }

    public static DynamicError overflowUnderflow() {
        return DynamicError.make_error("FODT0002", "Overflow/underflow in duration operation.", null, null);
    }

    public static DynamicError nan() {
        return DynamicError.make_error("FOCA0005", "NaN supplied as float/double value.", null, null);
    }

    public static DynamicError invalidLexicalValue(Throwable cause) {
        return DynamicError.make_error("FOCA0002", "Invalid lexical value.", null, cause);
    }

    public static DynamicError overflowDateTime() {
        return DynamicError.make_error("FODT0001", "Overflow/underflow in date/time operation", null, null);
    }

    public static DynamicError inconsistentTimeZone() {
        return DynamicError.make_error("FORG0008", "The two arguments to fn:dateTime have inconsistent timezones", null, null);
    }
}

