/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractXPath2EngineImpl {
    private DynamicContext fXpath2DynamicContext = null;
    private Document fDomDoc = null;

    public DynamicContext initXPath2DynamicContext(XSModel xSModel, Document document, Map map) {
        this.fXpath2DynamicContext = new DefaultDynamicContext(xSModel, document);
        NamespaceSupport namespaceSupport = (NamespaceSupport)map.get("XPATH2_NS_CONTEXT");
        Boolean bl = (Boolean)map.get("CTA-EVALUATOR");
        if (bl != null && bl.booleanValue()) {
            String[] stringArray = namespaceSupport.getNamespaceBindingInfo();
            List list = this.getPrefixesXS11CTA(stringArray);
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                this.addNamespaceBindingToXPath2DynamicContext(string, this.getURIXS11CTA(string, stringArray));
            }
        } else {
            Enumeration enumeration = namespaceSupport.getAllPrefixes();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addNamespaceBindingToXPath2DynamicContext(string, namespaceSupport.getURI(string));
            }
            this.addNamespaceBindingToXPath2DynamicContext("xml", "http://www.w3.org/XML/1998/namespace");
        }
        this.fXpath2DynamicContext.add_function_library(new FnFunctionLibrary());
        this.fXpath2DynamicContext.add_function_library(new XSCtrLibrary());
        this.fDomDoc = document;
        return this.fXpath2DynamicContext;
    }

    protected void addNamespaceBindingToXPath2DynamicContext(String string, String string2) {
        this.fXpath2DynamicContext.add_namespace(string, string2);
    }

    protected boolean evaluateXPathExpr(XPath xPath, Element element) throws Exception {
        ResultSequence resultSequence;
        StaticNameResolver staticNameResolver = new StaticNameResolver(this.fXpath2DynamicContext);
        staticNameResolver.check(xPath);
        DefaultEvaluator defaultEvaluator = null;
        if (element != null) {
            defaultEvaluator = new DefaultEvaluator(this.fXpath2DynamicContext, this.fDomDoc, (Node)this.fDomDoc.getDocumentElement());
            resultSequence = ResultSequenceFactory.create_new();
            resultSequence.add(new ElementType(element));
            this.fXpath2DynamicContext.set_focus(new Focus(resultSequence));
        } else {
            defaultEvaluator = new DefaultEvaluator(this.fXpath2DynamicContext, null);
        }
        resultSequence = defaultEvaluator.evaluate(xPath);
        boolean bl = false;
        if (resultSequence == null) {
            bl = false;
        } else if (resultSequence.size() == 1) {
            AnyType anyType = resultSequence.get(0);
            if (anyType instanceof XSBoolean) {
                XSBoolean xSBoolean = (XSBoolean)anyType;
                bl = xSBoolean.value();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected XPath compileXPathStr(String string, XSAssertImpl xSAssertImpl, XSDHandler xSDHandler, Element element) {
        JFlexCupParser jFlexCupParser = new JFlexCupParser();
        XPath xPath = null;
        try {
            xPath = jFlexCupParser.parse("boolean(" + string + ")", true);
        }
        catch (XPathParserException xPathParserException) {
            if ("Expression starts with / or //".equals(xPathParserException.getMessage())) {
                xSDHandler.reportSchemaWarning("cvc-xpath.3.13.4.2b", new Object[]{xSAssertImpl.getTest().getXPathStr(), XS11TypeHelper.getSchemaTypeName(xSAssertImpl.getTypeDefinition())}, element);
            }
            xSDHandler.reportSchemaError("cvc-xpath.3.13.4.2a", new Object[]{xSAssertImpl.getTest().getXPathStr(), XS11TypeHelper.getSchemaTypeName(xSAssertImpl.getTypeDefinition())}, element);
        }
        return xPath;
    }

    private List getPrefixesXS11CTA(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length && stringArray[i] != null; i += 2) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private String getURIXS11CTA(String string, String[] stringArray) {
        String string2 = null;
        for (int i = 0; i < stringArray.length && stringArray[i] != null; i += 2) {
            if (!string.equals(stringArray[i])) continue;
            string2 = stringArray[i + 1];
            break;
        }
        return string2;
    }
}

