/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.pack200.Pack200Utils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class Pack200Normalize
extends Task {
    private File src;
    private File dest;
    private boolean force = false;
    private Map<String, String> properties = new HashMap<String, String>();

    public void setSrcFile(File s) {
        this.src = s;
    }

    public void setDestFile(File d) {
        this.dest = d;
    }

    public void setForce(boolean b) {
        this.force = b;
    }

    public void addConfiguredProperty(Environment.Variable prop) {
        prop.validate();
        this.properties.put(prop.getKey(), prop.getValue());
    }

    @Override
    public void execute() {
        this.validate();
        if (this.isOutOfDate()) {
            this.normalize();
        } else if (this.dest != null) {
            this.log(this.src + " not normalized as " + this.dest + " is up-to-date.", 3);
        } else {
            this.log(this.src + " not normalized as force attribute is false.", 3);
        }
    }

    private void validate() {
        if (this.src == null) {
            throw new BuildException("srcFile attribute is required");
        }
        if (!this.src.exists()) {
            throw new BuildException(this.src + " doesn't exists");
        }
        if (!this.src.isFile()) {
            throw new BuildException(this.src + " must be a file");
        }
        if (this.dest != null && this.dest.isDirectory()) {
            throw new BuildException(this.dest + " must be a file");
        }
    }

    private boolean isOutOfDate() {
        return this.force || this.dest != null && SelectorUtils.isOutOfDate((Resource)new FileResource(this.src), (Resource)new FileResource(this.dest), FileUtils.getFileUtils().getFileTimestampGranularity());
    }

    private void normalize() {
        if (this.dest != null) {
            this.log("Normalizing " + this.src + " to " + this.dest + ".");
        } else {
            this.log("Normalizing " + this.src + ".");
        }
        try {
            Pack200Utils.normalize(this.src, this.dest != null ? this.dest : this.src, this.properties);
        }
        catch (IOException ex) {
            throw new BuildException("Caught an error normalizing " + this.src, ex);
        }
    }
}

