/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ant.compress.resources.CommonsCompressCompressorResource;
import org.apache.ant.compress.resources.Pack200Resource;
import org.apache.ant.compress.taskdefs.PackBase;
import org.apache.ant.compress.util.CompressorStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Resource;

public final class Pack200
extends PackBase {
    private Pack200StrategyEnum strategy = Pack200StrategyEnum.IN_MEMORY;
    private final Map<String, String> properties = new HashMap<String, String>();

    public Pack200() {
        super(new PackBase.ResourceWrapper(){

            @Override
            public CommonsCompressCompressorResource wrap(Resource dest) {
                return new Pack200Resource(dest);
            }
        });
        this.setFactory(new CompressorStreamFactory(){

            @Override
            public CompressorOutputStream getCompressorStream(OutputStream stream) throws IOException {
                return new Pack200CompressorOutputStream(stream, Pack200.this.strategy.getStrategy(), Pack200.this.properties);
            }

            @Override
            public CompressorInputStream getCompressorStream(InputStream stream) throws IOException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void setPack200Strategy(Pack200StrategyEnum s) {
        this.strategy = s;
    }

    public void addConfiguredProperty(Environment.Variable prop) {
        prop.validate();
        this.properties.put(prop.getKey(), prop.getValue());
    }

    public static final class Pack200StrategyEnum
    extends EnumeratedAttribute {
        private static final Map STRATEGIES = new HashMap();
        private static final String IN_MEMORY_KEY = "in-memory";
        private static final String TEMP_FILE_KEY = "temp-file";
        static final Pack200StrategyEnum IN_MEMORY;

        @Override
        public String[] getValues() {
            return new String[]{IN_MEMORY_KEY, TEMP_FILE_KEY};
        }

        private Pack200StrategyEnum(String name) {
            this.setValue(name);
        }

        public Pack200StrategyEnum() {
        }

        public Pack200Strategy getStrategy() {
            return (Pack200Strategy)((Object)STRATEGIES.get(this.getValue()));
        }

        static {
            STRATEGIES.put(IN_MEMORY_KEY, Pack200Strategy.IN_MEMORY);
            STRATEGIES.put(TEMP_FILE_KEY, Pack200Strategy.TEMP_FILE);
            IN_MEMORY = new Pack200StrategyEnum(IN_MEMORY_KEY);
        }
    }
}

