/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.ant.compress.util.Messages;
import org.apache.ant.compress.util.StreamHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public abstract class ExpandBase
extends Expand {
    private final ArchiveStreamFactory factory;
    private boolean skipUnreadable = false;

    protected ExpandBase(ArchiveStreamFactory factory) {
        this.factory = factory;
    }

    @Override
    public void setEncoding(String encoding) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding attribute", this.getLocation());
    }

    @Override
    public void setScanForUnicodeExtraFields(boolean b) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the scanForUnicodeExtraFields attribute", this.getLocation());
    }

    public void setSkipUnreadableEntries(boolean b) {
        this.skipUnreadable = b;
    }

    public boolean getSkipUnreadableEntries() {
        return this.skipUnreadable;
    }

    @Override
    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        InputStream is;
        block6: {
            if (!srcF.exists()) {
                throw new BuildException("Unable to expand " + srcF + " as the file does not exist", this.getLocation());
            }
            is = null;
            try {
                is = StreamHelper.getInputStream(this.factory, new FileResource(srcF), this.getEncoding());
                if (is != null) {
                    this.expandArchiveStream(srcF.getPath(), (ArchiveInputStream)is, dir);
                    break block6;
                }
                is = new FileInputStream(srcF);
                this.expandStream(srcF.getPath(), is, dir);
            }
            catch (IOException ioe) {
                try {
                    throw new BuildException("Error while expanding " + srcF.getPath() + "\n" + ioe.toString(), ioe, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
            }
        }
        FileUtils.close(is);
    }

    @Override
    protected void expandResource(Resource srcR, File dir) {
        if (!srcR.isExists()) {
            throw new BuildException("Unable to expand " + srcR.getName() + " as the it does not exist", this.getLocation());
        }
        try (InputStream i = srcR.getInputStream();){
            this.expandStream(srcR.getName(), i, dir);
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcR.getName(), ioe, this.getLocation());
        }
    }

    private void expandStream(String name, InputStream stream, File dir) throws IOException {
        try (ArchiveInputStream is = this.factory.getArchiveStream(new BufferedInputStream(stream), this.getEncoding());){
            this.expandArchiveStream(name, is, dir);
        }
    }

    private void expandArchiveStream(String name, ArchiveInputStream is, File dir) throws IOException {
        FileNameMapper mapper = this.getMapper();
        this.log("Expanding: " + name + " into " + dir, 2);
        boolean empty = true;
        ArchiveEntry ent = null;
        while (true) {
            Object e = is.getNextEntry();
            ent = (ArchiveEntry)e;
            if (e == null) break;
            if (this.skipUnreadable && !is.canReadEntryData(ent)) {
                this.log(Messages.skippedIsUnreadable(ent));
                continue;
            }
            empty = false;
            this.log("extracting " + ent.getName(), 4);
            this.extractFile(FileUtils.getFileUtils(), null, dir, is, ent.getName(), ent.getLastModifiedDate(), ent.isDirectory(), mapper);
        }
        if (empty && this.getFailOnEmptyArchive()) {
            throw new BuildException("archive '" + name + "' is empty");
        }
        this.log("expand complete", 3);
    }
}

