/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.ZipResource;
import org.apache.ant.compress.util.Messages;
import org.apache.ant.compress.util.ZipStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;

public class ZipScanner
extends CommonsCompressArchiveScanner {
    public ZipScanner() {
        this(false, null);
    }

    public ZipScanner(boolean skipUnreadable, Project project) {
        super(new ZipStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            @Override
            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new ZipResource(archive, encoding, (ZipArchiveEntry)entry);
            }
        }, skipUnreadable, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        FileProvider fp = src.as(FileProvider.class);
        if (fp == null) {
            super.fillMapsFromArchive(src, encoding, fileEntries, matchFileEntries, dirEntries, matchDirEntries);
            return;
        }
        File srcFile = fp.getFile();
        ZipArchiveEntry entry = null;
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(srcFile, encoding);
            }
            catch (ZipException ex) {
                throw new BuildException("Problem reading " + srcFile, ex);
            }
            catch (IOException ex) {
                throw new BuildException("Problem opening " + srcFile, ex);
            }
            Enumeration<ZipArchiveEntry> e = zf.getEntries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                if (this.getSkipUnreadableEntries() && !zf.canReadEntryData(entry)) {
                    this.log(Messages.skippedIsUnreadable(entry));
                    continue;
                }
                ZipResource r = new ZipResource(srcFile, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = ZipScanner.trimSeparator(name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            throw throwable;
        }
        ZipFile.closeQuietly(zf);
    }
}

