/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ant.compress.resources.CommonsCompressArchiveResource;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.ant.compress.util.SevenZStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileProvider;

public final class SevenZResource
extends CommonsCompressArchiveResource {
    private Iterable<? extends SevenZMethodConfiguration> contentMethods;

    public SevenZResource() {
        super(new SevenZStreamFactory(), "7z");
    }

    public SevenZResource(File z, String enc, SevenZArchiveEntry e) {
        super((ArchiveStreamFactory)new SevenZStreamFactory(), "7z", z, (ArchiveEntry)e);
        this.setEntry(e);
    }

    public SevenZResource(Resource z, String enc, SevenZArchiveEntry e) {
        super((ArchiveStreamFactory)new SevenZStreamFactory(), "sevenz", z, (ArchiveEntry)e);
        this.setEntry(e);
    }

    public void setSevenZFile(File z) {
        this.setArchive(z);
    }

    public void setSevenZResource(Resource z) {
        this.addConfigured(z);
    }

    public File getSevenZFile() {
        FileProvider fp = this.getArchive().as(FileProvider.class);
        return fp != null ? fp.getFile() : null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        File f = this.getSevenZFile();
        if (f == null) {
            return super.getInputStream();
        }
        final SevenZFile z = new SevenZFile(f);
        SevenZArchiveEntry ze = z.getNextEntry();
        while (ze != null) {
            if (ze.getName().equals(this.getName())) {
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return z.read();
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return z.read(b);
                    }

                    @Override
                    public void close() throws IOException {
                        z.close();
                    }

                    protected void finalize() throws Throwable {
                        try {
                            this.close();
                        }
                        finally {
                            super.finalize();
                        }
                    }
                };
            }
            ze = z.getNextEntry();
        }
        z.close();
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    public Iterable getContentMethods() {
        return this.contentMethods;
    }

    @Override
    protected void fetchEntry() {
        File f = this.getSevenZFile();
        if (f == null) {
            super.fetchEntry();
            return;
        }
        try (SevenZFile z = new SevenZFile(f);){
            SevenZArchiveEntry ze = z.getNextEntry();
            while (ze != null) {
                if (ze.getName().equals(this.getName())) {
                    this.setEntry(ze);
                    return;
                }
                ze = z.getNextEntry();
            }
            this.setEntry(null);
        }
        catch (IOException e) {
            this.log(e.getMessage(), 4);
            throw new BuildException(e);
        }
    }

    @Override
    protected void setEntry(ArchiveEntry e) {
        super.setEntry(e);
        if (e != null) {
            SevenZArchiveEntry ze = (SevenZArchiveEntry)e;
            this.contentMethods = ze.getContentMethods();
        }
    }
}

