/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.apache.ant.compress.resources.ArFileSet;
import org.apache.ant.compress.resources.ArjFileSet;
import org.apache.ant.compress.resources.CpioFileSet;
import org.apache.ant.compress.resources.DumpFileSet;
import org.apache.ant.compress.resources.SevenZFileSet;
import org.apache.ant.compress.resources.TarFileSet;
import org.apache.ant.compress.resources.ZipFileSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.CollectionUtils;

public class Archives
extends DataType
implements ResourceCollection,
Cloneable {
    private Union zips = new Union();
    private Union tars = new Union();
    private Union ars = new Union();
    private Union cpios = new Union();
    private Union arjs = new Union();
    private Union dumps = new Union();
    private Union sevenzs = new Union();

    public Union createZips() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.zips;
    }

    public Union createTars() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.tars;
    }

    public Union createArs() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.ars;
    }

    public Union createArjs() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.arjs;
    }

    public Union createCpios() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.cpios;
    }

    public Union createDumps() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.dumps;
    }

    public Union createSevenzs() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        return this.sevenzs;
    }

    @Override
    public int size() {
        if (this.isReference()) {
            return ((Archives)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        int total = 0;
        Iterator i = this.grabArchives();
        while (i.hasNext()) {
            total += ((ResourceCollection)i.next()).size();
        }
        return total;
    }

    @Override
    public Iterator iterator() {
        if (this.isReference()) {
            return ((Archives)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        LinkedList l = new LinkedList();
        Iterator i = this.grabArchives();
        while (i.hasNext()) {
            l.addAll(CollectionUtils.asCollection(((ResourceCollection)i.next()).iterator()));
        }
        return l.iterator();
    }

    @Override
    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((Archives)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        return false;
    }

    @Override
    public void setRefid(Reference r) {
        if (this.zips.getResourceCollections().size() > 0 || this.ars.getResourceCollections().size() > 0 || this.cpios.getResourceCollections().size() > 0 || this.arjs.getResourceCollections().size() > 0 || this.dumps.getResourceCollections().size() > 0 || this.sevenzs.getResourceCollections().size() > 0 || this.tars.getResourceCollections().size() > 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    @Override
    public Object clone() {
        try {
            Archives a = (Archives)super.clone();
            a.zips = (Union)this.zips.clone();
            a.tars = (Union)this.tars.clone();
            a.ars = (Union)this.ars.clone();
            a.cpios = (Union)this.cpios.clone();
            a.arjs = (Union)this.arjs.clone();
            a.dumps = (Union)this.dumps.clone();
            a.sevenzs = (Union)this.sevenzs.clone();
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    protected Iterator grabArchives() {
        LinkedList<ArchiveFileSet> l = new LinkedList<ArchiveFileSet>();
        Iterator<Resource> iter = this.zips.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new ZipFileSet(), iter.next()));
        }
        iter = this.tars.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new TarFileSet(), iter.next()));
        }
        iter = this.ars.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new ArFileSet(), iter.next()));
        }
        iter = this.cpios.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new CpioFileSet(), iter.next()));
        }
        iter = this.arjs.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new ArjFileSet(), iter.next()));
        }
        iter = this.dumps.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new DumpFileSet(), iter.next()));
        }
        iter = this.sevenzs.iterator();
        while (iter.hasNext()) {
            l.add(this.configureArchive(new SevenZFileSet(), iter.next()));
        }
        return l.iterator();
    }

    protected ArchiveFileSet configureArchive(ArchiveFileSet afs, Resource src) {
        afs.setProject(this.getProject());
        afs.setSrcResource(src);
        return afs;
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            Archives.pushAndInvokeCircularReferenceCheck(this.zips, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.tars, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.ars, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.cpios, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.arjs, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.dumps, stk, p);
            Archives.pushAndInvokeCircularReferenceCheck(this.sevenzs, stk, p);
            this.setChecked(true);
        }
    }
}

