/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.conditions;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.resources.ArchiveResource;

public class HasMode
extends ProjectComponent
implements Condition {
    private ArchiveResource resource;
    private int mode = -1;

    public void add(ArchiveResource r) {
        if (this.resource != null) {
            throw new BuildException("only one resource can be tested");
        }
        this.resource = r;
    }

    public void setMode(String octalString) {
        this.mode = Integer.parseInt(octalString, 8);
    }

    protected void validate() throws BuildException {
        if (this.resource == null) {
            throw new BuildException("you must specify a resource");
        }
        if (this.mode < 0) {
            throw new BuildException("mode is required");
        }
    }

    @Override
    public boolean eval() throws BuildException {
        this.validate();
        int actual = this.resource.getMode();
        if (this.mode <= 4095) {
            actual &= 0xFFF;
        }
        this.log("expected: " + this.mode + " (octal " + Integer.toString(this.mode, 8) + "), actual: " + actual + " (octal " + Integer.toString(actual, 8) + ")", 3);
        return this.mode == actual;
    }
}

