/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.LittleEndianOutputStream;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.comp.zip.WinZipAesCipher;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.crypto.BufferedPartialBlockCipher;
import net.java.truevfs.comp.zip.crypto.CipherOutputStream;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.io.TeeOutputStream;

@NotThreadSafe
final class WinZipAesOutputStream
extends DecoratingOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final MacOutputStream mos;
    private final LittleEndianOutputStream leos;

    WinZipAesOutputStream(WinZipAesEntryParameters param, LittleEndianOutputStream leos) throws IOException {
        assert (null != param);
        try {
            assert (null != leos);
            AesKeyStrength keyStrength = param.getKeyStrength();
            int keyStrengthBits = keyStrength.getBits();
            int keyStrengthBytes = keyStrength.getBytes();
            byte[] salt = new byte[keyStrengthBytes / 2];
            new SecureRandom().nextBytes(salt);
            byte[] passwd = param.getWritePassword();
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
            gen.init(passwd, salt, 1000);
            assert (128 <= keyStrengthBits);
            KeyParameter keyParam = (KeyParameter)((PBEParametersGenerator)gen).generateDerivedParameters(2 * keyStrengthBits + 16);
            Arrays.fill(passwd, (byte)0);
            byte[] ctrIv = new byte[16];
            ParametersWithIV aesCtrParam = new ParametersWithIV(new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
            KeyParameter sha1HMacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
            BufferedPartialBlockCipher cipher = new BufferedPartialBlockCipher(new WinZipAesCipher());
            cipher.init(true, aesCtrParam);
            HMac mac = new HMac(new SHA1Digest());
            mac.init(sha1HMacParam);
            this.leos = leos;
            this.mos = new MacOutputStream(mac);
            this.out = new CipherOutputStream(cipher, new TeeOutputStream(leos, this.mos));
            leos.write(salt);
            this.writePasswordVerifier(param, keyParam);
        }
        catch (Throwable ex) {
            try {
                leos.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private void writePasswordVerifier(WinZipAesEntryParameters param, KeyParameter keyParam) throws IOException {
        this.leos.write(keyParam.getKey(), 2 * param.getKeyStrength().getBytes(), 2);
    }

    void finish() throws IOException {
        ((CipherOutputStream)this.out).finish();
        byte[] buf = this.mos.getMac();
        this.leos.write(buf, 0, buf.length / 2);
    }
}

