/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

class CheckedInputStreamWithSkipBufferSize
extends CheckedInputStream {
    private final int skipBufferSize;

    CheckedInputStreamWithSkipBufferSize(InputStream in, Checksum cksum, int skipBufferSize) {
        super(in, cksum);
        this.skipBufferSize = skipBufferSize;
    }

    @Override
    public long skip(long n) throws IOException {
        long len;
        byte[] buf = new byte[this.skipBufferSize];
        long total = 0L;
        while (0L < (len = n - total) && 0L <= (len = (long)this.read(buf, 0, len < (long)buf.length ? (int)len : buf.length))) {
            total += len;
        }
        return total;
    }
}

