/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.logging;

import java.util.Formatter;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@ThreadSafe
public final class LocalizedLogger
implements Logger {
    private final Logger logger;
    private final ResourceBundle bundle;

    public LocalizedLogger(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz), ResourceBundle.getBundle(clazz.getName()));
    }

    LocalizedLogger(Logger logger, ResourceBundle bundle) {
        assert (null != logger);
        assert (null != bundle);
        this.logger = logger;
        this.bundle = bundle;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.bundle.getString(msg));
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (this.logger.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.bundle.getString(msg));
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (this.logger.isTraceEnabled(marker)) {
            this.logger.trace(marker, new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled(marker)) {
            this.logger.trace(marker, new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.logger.isTraceEnabled(marker)) {
            this.logger.trace(marker, new Formatter().format(this.bundle.getString(format), argArray).toString());
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (this.logger.isTraceEnabled(marker)) {
            this.logger.trace(marker, this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.bundle.getString(msg));
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.logger.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.bundle.getString(msg));
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.logger.isDebugEnabled(marker)) {
            this.logger.debug(marker, new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled(marker)) {
            this.logger.debug(marker, new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.logger.isDebugEnabled(marker)) {
            this.logger.debug(marker, new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.logger.isDebugEnabled(marker)) {
            this.logger.debug(marker, this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.bundle.getString(msg));
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.logger.isInfoEnabled(marker)) {
            this.logger.info(marker, this.bundle.getString(msg));
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.logger.isInfoEnabled(marker)) {
            this.logger.info(marker, new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled(marker)) {
            this.logger.info(marker, new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (this.logger.isInfoEnabled(marker)) {
            this.logger.info(marker, new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.logger.isInfoEnabled(marker)) {
            this.logger.info(marker, this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.bundle.getString(msg));
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.logger.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.bundle.getString(msg));
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.logger.isWarnEnabled(marker)) {
            this.logger.warn(marker, new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled(marker)) {
            this.logger.warn(marker, new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.logger.isWarnEnabled(marker)) {
            this.logger.warn(marker, new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.logger.isWarnEnabled(marker)) {
            this.logger.warn(marker, this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.bundle.getString(msg));
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.bundle.getString(msg), t);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.logger.isErrorEnabled(marker)) {
            this.logger.error(marker, this.bundle.getString(msg));
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.logger.isErrorEnabled(marker)) {
            this.logger.error(marker, new Formatter().format(this.bundle.getString(format), arg).toString());
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled(marker)) {
            this.logger.error(marker, new Formatter().format(this.bundle.getString(format), arg1, arg2).toString());
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (this.logger.isErrorEnabled(marker)) {
            this.logger.error(marker, new Formatter().format(this.bundle.getString(format), arguments).toString());
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.logger.isErrorEnabled(marker)) {
            this.logger.error(marker, this.bundle.getString(msg), t);
        }
    }
}

