/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.beans.Transient;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.java.truecommons.key.spec.AbstractSecretKey;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.PbeParameters;
import net.java.truecommons.shed.Buffers;
import net.java.truecommons.shed.Option;

public abstract class AbstractPbeParameters<P extends AbstractPbeParameters<P, S>, S extends KeyStrength>
extends AbstractSecretKey<P>
implements PbeParameters<P, S> {
    private Option<S> keyStrength = Option.none();

    @Override
    public void reset() {
        super.reset();
        this.keyStrength = Option.none();
    }

    @Override
    @Transient
    @Nullable
    public char[] getPassword() {
        return Buffers.charArray(this.getSecret());
    }

    @Override
    public void setPassword(@Nullable char[] password) {
        this.setSecret(Buffers.byteBuffer(password));
    }

    @Override
    @Transient
    @Nullable
    public S getKeyStrength() {
        return (S)((KeyStrength)this.keyStrength.orNull());
    }

    @Override
    public void setKeyStrength(@Nullable S keyStrength) {
        this.keyStrength = Option.apply(keyStrength);
    }

    public int getKeyStrengthBits() {
        Iterator i$ = this.keyStrength.iterator();
        if (i$.hasNext()) {
            KeyStrength s = (KeyStrength)i$.next();
            return s.getBits();
        }
        return 0;
    }

    public void setKeyStrengthBits(int bits) {
        if (0 != bits) {
            for (KeyStrength s : this.getAllKeyStrengths()) {
                if (s.getBits() != bits) continue;
                this.keyStrength = Option.some(s);
                return;
            }
            throw new IllegalArgumentException();
        }
        this.keyStrength = Option.none();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractPbeParameters that = (AbstractPbeParameters)obj;
        return this.keyStrength.equals(that.keyStrength);
    }

    @Override
    public int hashCode() {
        int c = super.hashCode();
        c = 31 * c + this.keyStrength.hashCode();
        return c;
    }

    @Override
    public String toString() {
        return String.format("%s[keystrength=%s]", super.toString(), this.keyStrength.orNull());
    }
}

