/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.util.Map;
import java.util.ServiceConfigurationError;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyManagerMap;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.UniqueObject;

@Immutable
public abstract class AbstractKeyManagerMap
extends UniqueObject
implements KeyManagerMap,
Container<Map<Class<?>, KeyManager<?>>> {
    @Override
    @Nullable
    public final <K> KeyManager<K> manager(Class<K> type) {
        KeyManager m = (KeyManager)this.get().get(type);
        if (null == m) {
            throw new ServiceConfigurationError("No key manager available for " + type + ".");
        }
        return m;
    }

    @Override
    public abstract Map<Class<?>, KeyManager<?>> get();

    public String toString() {
        return String.format("%s[keyManagers=%s]", this.getClass().getName(), this.get());
    }
}

