/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.utils.collections;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongLinkedHashMap<T>
implements Iterable<MapEntry<T>> {
    private final TLongObjectMap<Node<T>> map;
    private final boolean orderByAccess;
    private final DoubleLinkedList<T> list = new DoubleLinkedList();

    public LongLinkedHashMap() {
        this.map = new TLongObjectHashMap<Node<T>>();
        this.orderByAccess = false;
    }

    public LongLinkedHashMap(int capacity) {
        this.map = new TLongObjectHashMap<Node<T>>(capacity);
        this.orderByAccess = false;
    }

    public LongLinkedHashMap(int capacity, float loadFactor) {
        this(capacity, loadFactor, false);
    }

    public LongLinkedHashMap(int capacity, float loadFactor, boolean orderByAccess) {
        this.map = new TLongObjectHashMap<Node<T>>(capacity, loadFactor);
        this.orderByAccess = orderByAccess;
    }

    public final T get(long key) {
        Node<T> node = this.map.get(key);
        if (node != null) {
            if (this.orderByAccess) {
                this.list.moveToHead(node);
            }
            return (T)((Node)node).item;
        }
        return null;
    }

    public final T put(long key, T value) {
        Object lastValue;
        Node<T> node = this.map.get(key);
        if (node == null) {
            lastValue = null;
            this.map.put(key, this.list.add(value, key));
            this.checkEldestEntry();
        } else {
            lastValue = ((Node)node).item;
            ((Node)node).item = value;
        }
        return (T)lastValue;
    }

    public final T remove(long key) {
        return this.list.remove(this.map.remove(key));
    }

    public final int size() {
        return ((DoubleLinkedList)this.list).size;
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final void clear() {
        this.map.clear();
        this.list.clear();
    }

    public final boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public final boolean containsValue(T value) {
        return this.list.contains(value);
    }

    @Override
    public Iterator<MapEntry<T>> iterator() {
        return new MapEntryIterator();
    }

    public boolean equals(Object o) {
        return o instanceof LongLinkedHashMap && this.list.equals(((LongLinkedHashMap)o).list);
    }

    protected boolean removeEldestEntry(MapEntry<T> entry) {
        return false;
    }

    private void checkEldestEntry() {
        Node<T> first = this.list.firstNode();
        if (first != null && this.removeEldestEntry(first)) {
            this.map.remove(((Node)first).key);
            this.list.remove(first);
        }
    }

    private static final class Node<T>
    implements MapEntry<T> {
        private T item;
        private long key;
        private Node<T> previous;
        private Node<T> next;

        public Node() {
        }

        public Node(T item, long key) {
            this.item = item;
            this.key = key;
        }

        public boolean equals(Node otherNode) {
            return this.key != otherNode.key || !this.item.equals(otherNode.item);
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.item;
        }

        @Override
        public T setValue(T newValue) {
            T lastValue = this.item;
            this.item = newValue;
            return lastValue;
        }
    }

    private static final class DoubleLinkedList<T> {
        private final Node<T> tail = new Node();
        private Node<T> head = this.tail;
        private int size;

        public boolean equals(Object o) {
            if (o instanceof DoubleLinkedList) {
                DoubleLinkedList other = (DoubleLinkedList)o;
                if (this.size == other.size) {
                    Node otherNode = ((Node)other.tail).next;
                    Node node = ((Node)this.tail).next;
                    while (node != null) {
                        if (!node.equals(otherNode)) {
                            return false;
                        }
                        otherNode = otherNode.next;
                        node = node.next;
                    }
                    return true;
                }
            }
            return false;
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void clear() {
            ((Node)this.tail).next = null;
            this.head = this.tail;
            this.size = 0;
        }

        public boolean contains(T item) {
            Node node = ((Node)this.tail).next;
            while (node != null) {
                if (node.item.equals(item)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        public Node<T> add(T item, long key) {
            return this.add(new Node<T>(item, key));
        }

        public T remove(Node<T> node) {
            if (node != null) {
                ((Node)node).previous.next = ((Node)node).next;
                if (((Node)node).next != null) {
                    ((Node)node).next.previous = ((Node)node).previous;
                }
                if (node == this.head) {
                    this.head = ((Node)node).previous;
                }
                ((Node)node).previous = null;
                ((Node)node).next = null;
                --this.size;
                return (T)((Node)node).item;
            }
            return null;
        }

        public void moveToHead(Node<T> node) {
            if (node != this.head) {
                this.remove(node);
                this.add(node);
            }
        }

        public Node<T> firstNode() {
            return ((Node)this.tail).next;
        }

        private Node<T> add(Node<T> node) {
            ((Node)this.head).next = (Node)node;
            ((Node)node).previous = (Node)this.head;
            this.head = node;
            ++this.size;
            return node;
        }
    }

    private class MapEntryIterator
    implements Iterator<MapEntry<T>> {
        private Node<T> current;

        public MapEntryIterator() {
            this.current = LongLinkedHashMap.this.list.tail;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != null;
        }

        @Override
        public MapEntry<T> next() {
            if (this.current.next != null) {
                this.current = this.current.next;
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current.previous != null) {
                LongLinkedHashMap.this.remove(this.current.key);
            }
        }
    }

    public static interface MapEntry<T> {
        public long getKey();

        public T getValue();

        public T setValue(T var1);
    }
}

