/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.utils.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class IdentityHashSet<T>
extends AbstractSet<T>
implements Cloneable {
    private final Map<T, Object> map = new IdentityHashMap<T, Object>();

    public IdentityHashSet() {
    }

    public IdentityHashSet(Collection<? extends T> initialObjects) {
        this.addAll(initialObjects);
    }

    @Override
    public boolean add(T object) {
        return this.map.put(object, object) == object;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public IdentityHashSet<T> clone() {
        return new IdentityHashSet<T>(this.map.keySet());
    }
}

