/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.multisequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;

public final class MultiSequenceReverseMatcher
implements MultiSequenceMatcher {
    private final MultiSequenceMatcher reversed;
    private final Map<SequenceMatcher, SequenceMatcher> reverseToOriginals = new IdentityHashMap<SequenceMatcher, SequenceMatcher>();

    public MultiSequenceReverseMatcher(MultiSequenceMatcher original) {
        List<SequenceMatcher> originalSequences = original.getSequenceMatchers();
        ArrayList<SequenceMatcher> reverseSequences = new ArrayList<SequenceMatcher>();
        for (SequenceMatcher originalSequence : originalSequences) {
            SequenceMatcher reverseSequence = originalSequence.reverse();
            reverseSequences.add(reverseSequence);
            this.reverseToOriginals.put(reverseSequence, originalSequence);
        }
        this.reversed = original.newInstance(reverseSequences);
    }

    @Override
    public Collection<SequenceMatcher> allMatches(WindowReader reader, long matchPosition) throws IOException {
        return this.getOriginalSequences(this.reversed.allMatches(reader, matchPosition));
    }

    @Override
    public Collection<SequenceMatcher> allMatches(byte[] bytes, int matchPosition) {
        return this.getOriginalSequences(this.reversed.allMatches(bytes, matchPosition));
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        return this.getOriginalSequences(this.reversed.allMatchesBackwards(reader, matchPosition));
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(byte[] bytes, int matchPosition) {
        return this.getOriginalSequences(this.reversed.allMatchesBackwards(bytes, matchPosition));
    }

    @Override
    public SequenceMatcher firstMatch(WindowReader reader, long matchPosition) throws IOException {
        return this.getOriginalSequence(this.reversed.firstMatch(reader, matchPosition));
    }

    @Override
    public SequenceMatcher firstMatch(byte[] bytes, int matchPosition) {
        return this.getOriginalSequence(this.reversed.firstMatch(bytes, matchPosition));
    }

    @Override
    public SequenceMatcher firstMatchBackwards(WindowReader reader, long matchPosition) throws IOException {
        return this.getOriginalSequence(this.reversed.firstMatchBackwards(reader, matchPosition));
    }

    @Override
    public SequenceMatcher firstMatchBackwards(byte[] bytes, int matchPosition) {
        return this.getOriginalSequence(this.reversed.firstMatchBackwards(bytes, matchPosition));
    }

    @Override
    public boolean matchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        return this.reversed.matchesBackwards(reader, matchPosition);
    }

    @Override
    public boolean matchesBackwards(byte[] bytes, int matchPosition) {
        return this.reversed.matchesBackwards(bytes, matchPosition);
    }

    @Override
    public int getMinimumLength() {
        return this.reversed.getMinimumLength();
    }

    @Override
    public int getMaximumLength() {
        return this.reversed.getMaximumLength();
    }

    @Override
    public MultiSequenceMatcher reverse() {
        return new MultiSequenceReverseMatcher(this.reversed);
    }

    @Override
    public MultiSequenceMatcher newInstance(Collection<? extends SequenceMatcher> sequences) {
        return new MultiSequenceReverseMatcher(this.reversed.newInstance(sequences));
    }

    @Override
    public List<SequenceMatcher> getSequenceMatchers() {
        return this.reversed.getSequenceMatchers();
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        return this.reversed.matches(reader, matchPosition);
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return this.reversed.matches(bytes, matchPosition);
    }

    private Collection<SequenceMatcher> getOriginalSequences(Collection<SequenceMatcher> toTranslate) {
        ArrayList<SequenceMatcher> originals = new ArrayList<SequenceMatcher>(toTranslate.size());
        for (SequenceMatcher reverse : toTranslate) {
            originals.add(this.reverseToOriginals.get(reverse));
        }
        return originals;
    }

    private SequenceMatcher getOriginalSequence(SequenceMatcher toTranslate) {
        return this.reverseToOriginals.get(toTranslate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[reverse matcher:" + this.reversed + ']';
    }
}

