/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import java.io.IOException;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.Window;

public final class TwoLevelCache
extends AbstractFreeNotificationCache
implements WindowCache.WindowObserver {
    private final WindowCache primaryCache;
    private final WindowCache secondaryCache;

    public static TwoLevelCache create(WindowCache primaryCache, WindowCache secondaryCache) {
        TwoLevelCache twoLevels = new TwoLevelCache(primaryCache, secondaryCache);
        primaryCache.subscribe(twoLevels);
        secondaryCache.subscribe(twoLevels);
        return twoLevels;
    }

    private TwoLevelCache(WindowCache primaryCache, WindowCache secondaryCache) {
        this.primaryCache = primaryCache;
        this.secondaryCache = secondaryCache;
    }

    @Override
    public Window getWindow(long position) throws IOException {
        Window window = this.primaryCache.getWindow(position);
        if (window == null && (window = this.secondaryCache.getWindow(position)) != null) {
            this.addWindow(window);
        }
        return window;
    }

    @Override
    public void addWindow(Window window) throws IOException {
        this.primaryCache.addWindow(window);
    }

    @Override
    public void clear() throws IOException {
        IOException primaryException = null;
        try {
            this.primaryCache.clear();
        }
        catch (IOException primaryCacheException) {
            primaryException = primaryCacheException;
        }
        this.secondaryCache.clear();
        if (primaryException != null) {
            throw primaryException;
        }
    }

    @Override
    public void windowFree(Window window, WindowCache fromCache) throws IOException {
        if (fromCache == this.primaryCache) {
            this.secondaryCache.addWindow(window);
        } else if (fromCache == this.secondaryCache) {
            this.notifyWindowFree(window, fromCache);
        }
    }

    public WindowCache getPrimaryCache() {
        return this.primaryCache;
    }

    public WindowCache getSecondaryCache() {
        return this.secondaryCache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[primary cache: " + this.primaryCache + " secondary cache: " + this.secondaryCache + ']';
    }
}

