/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.windows.Window;

public final class TopAndTailFixedLengthCache
extends AbstractFreeNotificationCache {
    final long topCacheEnd;
    final long tailCacheStart;
    final TLongObjectMap<Window> cache;

    public TopAndTailFixedLengthCache(long length, long topTailBytes) {
        this(length, topTailBytes, topTailBytes);
    }

    public TopAndTailFixedLengthCache(long length, long topCacheBytes, long tailCacheBytes) {
        this.topCacheEnd = topCacheBytes;
        this.tailCacheStart = length - tailCacheBytes - 1L;
        this.cache = new TLongObjectHashMap<Window>();
    }

    @Override
    public Window getWindow(long position) {
        return this.cache.get(position);
    }

    @Override
    public void addWindow(Window window) {
        long windowPos = window.getWindowPosition();
        if (windowPos < this.topCacheEnd || windowPos > this.tailCacheStart) {
            this.cache.put(windowPos, window);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

