/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.windows.Window;

public final class TopAndTailCache
extends AbstractFreeNotificationCache {
    private final TLongObjectMap<Window> cache = new TLongObjectHashMap<Window>();
    private final List<Window> tailCacheEntries = new ArrayList<Window>();
    private final int firstCacheSize;
    private final int secondCacheSize;
    private long lastPositionSeen;
    private int nextTailCacheToCheck;

    public TopAndTailCache(int cacheSize) {
        this(cacheSize, cacheSize);
    }

    public TopAndTailCache(int firstCacheSize, int secondCacheSize) {
        this.firstCacheSize = firstCacheSize;
        this.secondCacheSize = secondCacheSize;
    }

    @Override
    public Window getWindow(long position) {
        return this.cache.get(position);
    }

    @Override
    public void addWindow(Window window) throws IOException {
        long windowPosition = window.getWindowPosition();
        long windowEnd = window.getWindowEndPosition();
        if (windowEnd > this.lastPositionSeen) {
            this.lastPositionSeen = windowEnd;
        }
        long tailCacheStart = this.lastPositionSeen - (long)this.secondCacheSize + 1L;
        if (windowPosition < (long)this.firstCacheSize) {
            this.cache.put(windowPosition, window);
        } else if (windowEnd >= tailCacheStart) {
            this.cache.put(windowPosition, window);
            this.tailCacheEntries.add(window);
            this.checkNonTailWindows(tailCacheStart);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.tailCacheEntries.clear();
    }

    private void checkNonTailWindows(long tailCacheStart) throws IOException {
        for (int repeat = 0; repeat < 2; ++repeat) {
            int numberOfCacheEntries = this.tailCacheEntries.size();
            if (numberOfCacheEntries <= 1) continue;
            int nextToCheck = this.nextTailCacheToCheck;
            Window window = this.tailCacheEntries.get(nextToCheck);
            if (window.getWindowEndPosition() < tailCacheStart) {
                this.cache.remove(window.getWindowPosition());
                this.tailCacheEntries.remove(nextToCheck);
                this.notifyWindowFree(window, this);
                continue;
            }
            this.nextTailCacheToCheck = (nextToCheck + 1) % numberOfCacheEntries;
        }
    }
}

